/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_19_R3;

import com.mojang.serialization.Lifecycle;
import de.cubeside.nmsutils.BiomeUtils;
import de.cubeside.nmsutils.NMSUtils;
import de.cubeside.nmsutils.biome.CustomBiome;
import de.cubeside.nmsutils.biome.Precipitation;
import de.cubeside.nmsutils.util.ReobfHelper;
import de.cubeside.nmsutils.v1_19_R3.CustomBiomeImpl;
import de.cubeside.nmsutils.v1_19_R3.NMSUtilsImpl;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;

public class BiomeUtilsImpl
implements BiomeUtils {
    private final NMSUtilsImpl nmsUtils;
    private HashMap<NamespacedKey, CustomBiomeImpl> customBiomes;
    private HashMap<cnf, CustomBiomeImpl> customBiomesByBiome;
    private Collection<? extends CustomBiome> unmodifiableCustomBiomes;
    private static final Field FIELD_MAPPED_REGISTRY_FROZEN = ReobfHelper.getFieldByMojangName(hl.class, (String)"frozen");
    private static final Field FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS = ReobfHelper.getFieldByMojangName(hl.class, (String)"unregisteredIntrusiveHolders");

    public BiomeUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
        this.customBiomes = new HashMap();
        this.customBiomesByBiome = new HashMap();
        this.unmodifiableCustomBiomes = Collections.unmodifiableCollection(this.customBiomes.values());
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    public CustomBiome registerCustomBiome(NamespacedKey id, float downfall, float temperature, Precipitation precipitation, Integer fogColor, Integer waterColor, Integer waterFogColor, Integer skyColor, Integer foliageColor, Integer grassColor) {
        Server server = this.nmsUtils.getPlugin().getServer();
        CraftServer craftserver = (CraftServer)server;
        ahq dedicatedserver = craftserver.getServer();
        adc newKey = adc.a((adc)jb.an, (add)new add(id.getNamespace(), id.getKey()));
        adc oldKey = cnm.i;
        hz registrywritable = (hz)dedicatedserver.aX().d(jb.an);
        try {
            FIELD_MAPPED_REGISTRY_FROZEN.set(registrywritable, false);
            FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS.set(registrywritable, new IdentityHashMap());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        cnf forestbiome = (cnf)registrywritable.a(oldKey);
        cnf.a builder = new cnf.a();
        builder.b(downfall);
        builder.a(temperature);
        boolean mojangPrecipitation = false;
        if (precipitation == Precipitation.RAIN) {
            mojangPrecipitation = true;
        } else if (precipitation == Precipitation.SNOW) {
            mojangPrecipitation = true;
        }
        builder.a(mojangPrecipitation);
        builder.a(forestbiome.b());
        builder.a(forestbiome.d());
        builder.a(cnf.d.a);
        cnl.a effects = new cnl.a();
        effects.b(waterColor == null ? forestbiome.i() : waterColor.intValue());
        effects.c(waterFogColor == null ? forestbiome.j() : waterFogColor.intValue());
        effects.a(fogColor == null ? forestbiome.e() : fogColor.intValue());
        effects.d(skyColor == null ? forestbiome.a() : skyColor.intValue());
        if (foliageColor != null) {
            effects.e(foliageColor.intValue());
        }
        if (grassColor != null) {
            effects.f(grassColor.intValue());
        }
        effects.a(cnd.b);
        builder.a(effects.a());
        cnf newbiome = builder.a();
        registrywritable.f((Object)newbiome);
        hd.c biomeHolder = registrywritable.a(newKey, (Object)newbiome, Lifecycle.stable());
        try {
            FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS.set(registrywritable, null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        CustomBiomeImpl impl = new CustomBiomeImpl(id, (adc<cnf>)newKey, newbiome, (hd.c<cnf>)biomeHolder);
        this.customBiomes.put(id, impl);
        this.customBiomesByBiome.put(newbiome, impl);
        return new CustomBiomeImpl(id, (adc<cnf>)newKey, newbiome, (hd.c<cnf>)biomeHolder);
    }

    public Collection<? extends CustomBiome> getAllCustomBiomes() {
        return this.unmodifiableCustomBiomes;
    }

    public CustomBiome getCustomBiome(NamespacedKey id) {
        return this.customBiomes.get(id);
    }

    public CustomBiome getCustomBiomeAt(Location location) {
        hd biomeHolder;
        ddy chunk;
        location.getWorld().getChunkAt(location);
        aip level = ((CraftWorld)location.getWorld()).getHandle();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        gt pos = new gt(x, 0, z);
        if (level.o(pos) && (chunk = level.l(pos)) != null && (biomeHolder = chunk.getNoiseBiome(x >> 2, y >> 2, z >> 2)).b()) {
            cnf biome = (cnf)biomeHolder.a();
            return this.customBiomesByBiome.get(biome);
        }
        return null;
    }
}

