/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_19_R1_1;

import com.destroystokyo.paper.entity.ai.VanillaGoal;
import de.cubeside.nmsutils.EntityUtils;
import de.cubeside.nmsutils.NMSUtils;
import de.cubeside.nmsutils.util.ReobfHelper;
import de.cubeside.nmsutils.v1_19_R1_1.NMSUtilsImpl;
import de.cubeside.nmsutils.v1_19_R1_1.PathfinderGoalLimitedRandomStrollLand;
import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftBat;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftRaider;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftVex;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftWolf;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Wolf;
import org.bukkit.util.Vector;

public class EntityUtilsImpl
implements EntityUtils {
    private static final Field FIELD_BAT_TARGET = ReobfHelper.getFieldByMojangName(bmz.class, (String)"targetPosition");
    private static final Field FIELD_ENTITY_TRACKER = ReobfHelper.getFieldByMojangName(bbn.class, (String)"tracker");
    private final NMSUtilsImpl nmsUtils;

    public EntityUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    public void clearAI(Entity entity) {
        if (entity instanceof Mob) {
            this.nmsUtils.getPlugin().getServer().getMobGoals().removeAllGoals((Mob)entity);
        }
    }

    public void addGoalFloat(Mob mob) {
        if (!Bukkit.getMobGoals().hasGoal(mob, VanillaGoal.FLOAT)) {
            bce h = ((CraftMob)mob).getHandle();
            h.bS.a(1, (bip)new bij(h));
        }
    }

    public void addGoalLimitedStrollLand(Creature mob, double velocity, Function<Vector, Boolean> checkTargetFunction) {
        bcl h = ((CraftCreature)mob).getHandle();
        h.bS.a(7, (bip)new PathfinderGoalLimitedRandomStrollLand(h, velocity, checkTargetFunction));
    }

    public int getShulkerOpenState(Entity shulker) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return 0;
            }
            CraftShulker cs = (CraftShulker)shulker;
            return cs.getHandle().fP();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get shulker open state", e);
            return 0;
        }
    }

    public void setShulkerOpenState(Entity shulker, int state) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return;
            }
            state = Math.max(0, Math.min(127, state));
            CraftShulker cs = (CraftShulker)shulker;
            cs.getHandle().a(state);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set shulker open state", e);
        }
    }

    public boolean isPiglinDancing(Entity piglin) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return false;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            return cs.getHandle().fR();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get piglin dancing state", e);
            return false;
        }
    }

    public void setPiglinDancing(Entity piglin, boolean dancing) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            cs.getHandle().w(dancing);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set piglin dancing state", e);
        }
    }

    public void sendEntityPositionUpdate(Entity entity) {
        bbn handle = ((CraftEntity)entity).getHandle();
        try {
            aft.b ete = (aft.b)FIELD_ENTITY_TRACKER.get(handle);
            if (ete != null) {
                xe positionPacket = new xe(handle);
                ete.f.stream().forEach(viewer -> viewer.a((tc)positionPacket));
            }
        }
        catch (ReflectiveOperationException e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not send teleport packet", e);
        }
    }

    public void moveEntity(Entity e, double x, double y, double z) {
        bbn handle = ((CraftEntity)e).getHandle();
        handle.a(bci.a, new dwq(x, y, z));
    }

    public void moveEntity(Entity e, Vector v) {
        this.moveEntity(e, v.getX(), v.getY(), v.getZ());
    }

    public void setEntityHeadRotation(Entity e, float headRotation) {
        bbn handle = ((CraftEntity)e).getHandle();
        if (handle instanceof bcc) {
            ((bcc)handle).aZ = headRotation;
        } else {
            handle.l(headRotation);
        }
    }

    public float getEntityHeadRotation(Entity e) {
        bbn handle = ((CraftEntity)e).getHandle();
        return handle.cg();
    }

    public void setEntityYaw(Entity e, float yaw) {
        bbn handle = ((CraftEntity)e).getHandle();
        handle.o(yaw);
    }

    public float getEntityYaw(Entity e) {
        bbn handle = ((CraftEntity)e).getHandle();
        return handle.dq();
    }

    public void setEntityPitch(Entity e, float pitch) {
        bbn handle = ((CraftEntity)e).getHandle();
        handle.p(pitch);
    }

    public float getEntityPitch(Entity e) {
        bbn handle = ((CraftEntity)e).getHandle();
        return handle.ds();
    }

    public void setEntityNavigationTarget(Entity entity, Location target, double speed) {
        if (entity instanceof Bat) {
            try {
                FIELD_BAT_TARGET.set(((CraftBat)entity).getHandle(), new gt(target.getX(), target.getY(), target.getZ()));
            }
            catch (ReflectiveOperationException e) {
                this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "could not set field", e);
            }
        } else if (entity instanceof Vex) {
            bse entityVex = ((CraftVex)entity).getHandle();
            entityVex.A().a(target.getX(), target.getY(), target.getZ(), speed);
            if (entityVex.G() == null) {
                entityVex.z().a(target.getX(), target.getY(), target.getZ(), 180.0f, 20.0f);
            }
        } else if (entity instanceof CraftMob) {
            ((CraftMob)entity).getHandle().D().a(target.getX(), target.getY(), target.getZ(), speed);
        } else {
            throw new IllegalArgumentException("Cannot set the navigation target for this mob");
        }
    }

    public void setEntityLeftHanded(Entity ent, boolean left) {
        bbn nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof bce) {
            bce mob = (bce)nmsEntity;
            mob.t(left);
        }
    }

    public boolean isEntityLeftHanded(Entity ent) {
        bbn nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof bce) {
            bce mob = (bce)nmsEntity;
            return mob.fB();
        }
        return false;
    }

    public boolean isEntityInvisible(Entity entity) {
        bbn nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.bX();
    }

    public void setEntityInvisible(Entity entity, boolean invisible) {
        bbn nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.j(invisible);
    }

    public boolean hasEntityNoClip(Entity entity) {
        bbn nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.Q;
    }

    public void setEntityNoClip(Entity entity, boolean noClip) {
        bbn nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.Q = noClip;
    }

    public boolean areChunkEntitiesLoaded(Chunk c) {
        return ((CraftWorld)c.getWorld()).getHandle().c(cge.c((int)c.getX(), (int)c.getZ()));
    }

    public void loadChunkEntities(Chunk c) {
        int x = c.getX();
        int z = c.getZ();
        World world = c.getWorld();
        if (!world.isChunkLoaded(x, z)) {
            world.getChunkAt(x, z);
        }
        if (this.areChunkEntitiesLoaded(c)) {
            return;
        }
        agg serverLevel = ((CraftWorld)world).getHandle();
        serverLevel.P.a(new cge(x, z), czp.b);
        if (!this.areChunkEntitiesLoaded(c)) {
            serverLevel.n().c(() -> {
                if (this.areChunkEntitiesLoaded(c)) {
                    return true;
                }
                serverLevel.P.a();
                return this.areChunkEntitiesLoaded(c);
            });
        }
    }

    public void setOnGround(Entity entity, boolean onGround) {
        bbn nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.c(onGround);
    }

    public Entity getEntityById(World world, int id) {
        bbn entity = ((CraftWorld)world).getHandle().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void setPose(Entity entity, Pose pose) {
        bbn nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.b(bco.values()[pose.ordinal()]);
    }

    public void setWolfAngerTime(Wolf entity, int timeInTicks) {
        boh nmsEntity = ((CraftWolf)entity).getHandle();
        nmsEntity.a(timeInTicks);
    }

    public void setAggressive(Mob entity, boolean aggressive) {
        bce nmsEntity = ((CraftMob)entity).getHandle();
        nmsEntity.u(aggressive);
    }

    public boolean isAggressive(Mob entity) {
        bce nmsEntity = ((CraftMob)entity).getHandle();
        return nmsEntity.fC();
    }

    public boolean isCelebrating(Raider entity) {
        bvk nmsEntity = ((CraftRaider)entity).getHandle();
        return nmsEntity.ga();
    }

    public void setCelebrating(Raider entity, boolean celebrating) {
        bvk nmsEntity = ((CraftRaider)entity).getHandle();
        nmsEntity.z(celebrating);
    }
}

