/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_19_R1_0;

import de.cubeside.nmsutils.WorldUtils;
import de.cubeside.nmsutils.v1_19_R1_0.NMSUtilsImpl;
import java.util.ArrayList;
import java.util.logging.Level;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.entity.Player;

public class WorldUtilsImpl
implements WorldUtils {
    private final NMSUtilsImpl nmsUtils;

    public WorldUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    public void saveWorldNow(World world) {
        world.save();
        CraftWorld craftWorld = (CraftWorld)world;
        WorldServer handle = craftWorld.getHandle();
        try {
            handle.a(null, true, false);
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "Exception while saving world", e);
        }
    }

    public void forceUnloadWorldWithoutSaving(World world, Location playerTarget) {
        if (playerTarget.getWorld() == null || playerTarget.getWorld() == world) {
            throw new IllegalArgumentException("Valid target world required");
        }
        try {
            for (Player p : world.getPlayers()) {
                if (p.isDead()) {
                    p.spigot().respawn();
                }
                if (p.getWorld() != world) continue;
                p.teleport(playerTarget);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CraftWorld craftWorld = (CraftWorld)world;
        WorldServer handle = craftWorld.getHandle();
        if (!handle.w().isEmpty()) {
            for (EntityPlayer human : new ArrayList(handle.w())) {
                this.kickPlayer((Player)human.getBukkitEntity(), "Connection lost");
            }
            handle.w().clear();
        }
        if (!this.nmsUtils.getPlugin().getServer().unloadWorld(world, false)) {
            throw new IllegalStateException("Could not unload world");
        }
    }

    private void kickPlayer(Player player, String message) {
        player.kickPlayer(message);
    }
}

