/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_20_R2;

import com.destroystokyo.paper.entity.ai.VanillaGoal;
import de.cubeside.nmsutils.EntityUtils;
import de.cubeside.nmsutils.NMSUtils;
import de.cubeside.nmsutils.nbt.CompoundTag;
import de.cubeside.nmsutils.v1_20_R2.CompoundTagImpl;
import de.cubeside.nmsutils.v1_20_R2.NMSUtilsImpl;
import de.cubeside.nmsutils.v1_20_R2.PathfinderGoalLimitedRandomStrollLand;
import java.io.Serializable;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftBat;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftCamel;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftMob;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftRaider;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftVex;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftWolf;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Wolf;
import org.bukkit.util.Vector;

public class EntityUtilsImpl
implements EntityUtils {
    private final NMSUtilsImpl nmsUtils;

    public EntityUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    public void clearAI(Entity entity) {
        if (entity instanceof Mob) {
            this.nmsUtils.getPlugin().getServer().getMobGoals().removeAllGoals((Mob)entity);
        }
    }

    public void addGoalFloat(Mob mob) {
        if (!Bukkit.getMobGoals().hasGoal(mob, VanillaGoal.FLOAT)) {
            bji h = ((CraftMob)mob).getHandle();
            h.bO.a(1, (bqb)new bpv(h));
        }
    }

    public void addGoalLimitedStrollLand(Creature mob, double velocity, Function<Vector, Boolean> checkTargetFunction) {
        bjp h = ((CraftCreature)mob).getHandle();
        h.bO.a(7, (bqb)new PathfinderGoalLimitedRandomStrollLand(h, velocity, checkTargetFunction));
    }

    public void removeGoalLimitedStrollLand(Creature mob) {
        bjp h = ((CraftCreature)mob).getHandle();
        for (brp wrappedGoal : h.bO.b()) {
            bqb bqb2 = wrappedGoal.k();
            if (!(bqb2 instanceof PathfinderGoalLimitedRandomStrollLand)) continue;
            PathfinderGoalLimitedRandomStrollLand goal = (PathfinderGoalLimitedRandomStrollLand)bqb2;
            wrappedGoal.d();
            h.bO.a((bqb)goal);
            break;
        }
    }

    public int getShulkerOpenState(Entity shulker) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return 0;
            }
            CraftShulker cs = (CraftShulker)shulker;
            return cs.getHandle().gk();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get shulker open state", e);
            return 0;
        }
    }

    public void setShulkerOpenState(Entity shulker, int state) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return;
            }
            state = Math.max(0, Math.min(127, state));
            CraftShulker cs = (CraftShulker)shulker;
            cs.getHandle().b(state);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set shulker open state", e);
        }
    }

    public boolean isPiglinDancing(Entity piglin) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return false;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            return cs.getHandle().gl();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get piglin dancing state", e);
            return false;
        }
    }

    public void setPiglinDancing(Entity piglin, boolean dancing) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            cs.getHandle().x(dancing);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set piglin dancing state", e);
        }
    }

    public void sendEntityPositionUpdate(Entity entity) {
        biq handle = ((CraftEntity)entity).getHandle();
        aka.b ete = handle.tracker;
        if (ete != null) {
            aau positionPacket = new aau(handle);
            ete.f.stream().forEach(viewer -> viewer.b((vd)positionPacket));
        }
    }

    public void moveEntity(Entity e, double x, double y, double z) {
        biq handle = ((CraftEntity)e).getHandle();
        handle.a(bjm.a, new ehn(x, y, z));
    }

    public void moveEntity(Entity e, Vector v) {
        this.moveEntity(e, v.getX(), v.getY(), v.getZ());
    }

    public void setEntityHeadRotation(Entity e, float headRotation) {
        biq handle = ((CraftEntity)e).getHandle();
        if (handle instanceof bjg) {
            ((bjg)handle).aW = headRotation;
        } else {
            handle.n(headRotation);
        }
    }

    public float getEntityHeadRotation(Entity e) {
        biq handle = ((CraftEntity)e).getHandle();
        return handle.co();
    }

    public void setEntityYaw(Entity e, float yaw) {
        biq handle = ((CraftEntity)e).getHandle();
        handle.r(yaw);
    }

    public float getEntityYaw(Entity e) {
        biq handle = ((CraftEntity)e).getHandle();
        return handle.dB();
    }

    public void setEntityPitch(Entity e, float pitch) {
        biq handle = ((CraftEntity)e).getHandle();
        handle.s(pitch);
    }

    public float getEntityPitch(Entity e) {
        biq handle = ((CraftEntity)e).getHandle();
        return handle.dD();
    }

    public void setEntityNavigationTarget(Entity entity, Location target, double speed) {
        if (entity instanceof Bat) {
            ((CraftBat)entity).getHandle().bT = new gw(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        } else if (entity instanceof Vex) {
            bzw entityVex = ((CraftVex)entity).getHandle();
            entityVex.I().a(target.getX(), target.getY(), target.getZ(), speed);
            if (entityVex.q() == null) {
                entityVex.G().a(target.getX(), target.getY(), target.getZ(), 180.0f, 20.0f);
            }
        } else if (entity instanceof CraftMob) {
            ((CraftMob)entity).getHandle().L().a(target.getX(), target.getY(), target.getZ(), speed);
        } else {
            throw new IllegalArgumentException("Cannot set the navigation target for this mob: " + (Serializable)((Object)(entity == null ? "null" : entity.getType())));
        }
    }

    public void setEntityLeftHanded(Entity ent, boolean left) {
        biq nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof bji) {
            bji mob = (bji)nmsEntity;
            mob.u(left);
        }
    }

    public boolean isEntityLeftHanded(Entity ent) {
        biq nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof bji) {
            bji mob = (bji)nmsEntity;
            return mob.fU();
        }
        return false;
    }

    public boolean isEntityInvisible(Entity entity) {
        biq nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.cd();
    }

    public void setEntityInvisible(Entity entity, boolean invisible) {
        biq nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.j(invisible);
    }

    public boolean hasEntityNoClip(Entity entity) {
        biq nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.af;
    }

    public void setEntityNoClip(Entity entity, boolean noClip) {
        biq nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.af = noClip;
    }

    public boolean areChunkEntitiesLoaded(Chunk c) {
        return ((CraftWorld)c.getWorld()).getHandle().c(cpc.c((int)c.getX(), (int)c.getZ()));
    }

    public void loadChunkEntities(Chunk c) {
        this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Call to unimplemented method", new RuntimeException());
    }

    public void setOnGround(Entity entity, boolean onGround) {
        biq nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.c(onGround);
    }

    public Entity getEntityById(World world, int id) {
        biq entity = ((CraftWorld)world).getHandle().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void setPose(Entity entity, Pose pose) {
        biq nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.b(bjs.values()[pose.ordinal()]);
    }

    public void setWolfAngerTime(Wolf entity, int timeInTicks) {
        bvu nmsEntity = ((CraftWolf)entity).getHandle();
        nmsEntity.a(timeInTicks);
    }

    public void setAggressive(Mob entity, boolean aggressive) {
        bji nmsEntity = ((CraftMob)entity).getHandle();
        nmsEntity.v(aggressive);
    }

    public boolean isAggressive(Mob entity) {
        bji nmsEntity = ((CraftMob)entity).getHandle();
        return nmsEntity.fV();
    }

    public boolean isCelebrating(Raider entity) {
        cdc nmsEntity = ((CraftRaider)entity).getHandle();
        return nmsEntity.gu();
    }

    public void setCelebrating(Raider entity, boolean celebrating) {
        cdc nmsEntity = ((CraftRaider)entity).getHandle();
        nmsEntity.A(celebrating);
    }

    public void setCamelLastPoseChange(Camel entity, long tick) {
        bwd nmsEntity = ((CraftCamel)entity).getHandle();
        nmsEntity.a(nmsEntity.dL().V() - tick);
    }

    public long getCamelLastPoseChange(Camel entity) {
        bwd nmsEntity = ((CraftCamel)entity).getHandle();
        return nmsEntity.gr();
    }

    public boolean isCamelSitting(Camel entity) {
        bwd nmsEntity = ((CraftCamel)entity).getHandle();
        return nmsEntity.gl();
    }

    public CompoundTag getNbt(Entity entity) {
        biq nmsEntity = ((CraftEntity)entity).getHandle();
        qw compoundTag = nmsEntity.f(new qw());
        return new CompoundTagImpl(compoundTag);
    }

    public void setNbt(Entity entity, CompoundTag nbt) {
        qw nativeNbt = ((CompoundTagImpl)nbt).handle;
        biq nmsEntity = ((CraftEntity)entity).getHandle();
        UUID uuid = nmsEntity.cv();
        nmsEntity.g(nativeNbt);
        nmsEntity.a_(uuid);
    }

    public void mergeNbt(Entity entity, CompoundTag nbt) {
        qw newNbt;
        qw nativeNbt = ((CompoundTagImpl)nbt).handle;
        biq nmsEntity = ((CraftEntity)entity).getHandle();
        qw oldNbt = nmsEntity.f(new qw());
        if (!oldNbt.equals((Object)(newNbt = oldNbt.h().a(nativeNbt)))) {
            UUID uuid = nmsEntity.cv();
            nmsEntity.g(newNbt);
            nmsEntity.a_(uuid);
        }
    }
}

