/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_20_R2;

import com.mojang.serialization.Lifecycle;
import de.cubeside.nmsutils.BiomeUtils;
import de.cubeside.nmsutils.NMSUtils;
import de.cubeside.nmsutils.biome.CustomBiome;
import de.cubeside.nmsutils.biome.Precipitation;
import de.cubeside.nmsutils.util.ReobfHelper;
import de.cubeside.nmsutils.v1_20_R2.CustomBiomeImpl;
import de.cubeside.nmsutils.v1_20_R2.NMSUtilsImpl;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;

public class BiomeUtilsImpl
implements BiomeUtils {
    private final NMSUtilsImpl nmsUtils;
    private HashMap<NamespacedKey, CustomBiomeImpl> customBiomes;
    private HashMap<cqt, CustomBiomeImpl> customBiomesByBiome;
    private Collection<? extends CustomBiome> unmodifiableCustomBiomes;
    private static final Field FIELD_MAPPED_REGISTRY_FROZEN = ReobfHelper.getFieldByMojangName(hm.class, (String)"frozen");
    private static final Field FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS = ReobfHelper.getFieldByMojangName(hm.class, (String)"unregisteredIntrusiveHolders");

    public BiomeUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
        this.customBiomes = new HashMap();
        this.customBiomesByBiome = new HashMap();
        this.unmodifiableCustomBiomes = Collections.unmodifiableCollection(this.customBiomes.values());
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    public CustomBiome registerCustomBiome(NamespacedKey id, float downfall, float temperature, Precipitation precipitation, Integer fogColor, Integer waterColor, Integer waterFogColor, Integer skyColor, Integer foliageColor, Integer grassColor, BiomeUtils.GrassColorModifier grassColorModifier) {
        Server server = this.nmsUtils.getPlugin().getServer();
        CraftServer craftserver = (CraftServer)server;
        ajn dedicatedserver = craftserver.getServer();
        aev newKey = aev.a((aev)jc.ap, (aew)new aew(id.getNamespace(), id.getKey()));
        aev oldKey = cra.i;
        hz registrywritable = (hz)dedicatedserver.aU().d(jc.ap);
        try {
            FIELD_MAPPED_REGISTRY_FROZEN.set(registrywritable, false);
            FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS.set(registrywritable, new IdentityHashMap());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        cqt forestbiome = (cqt)registrywritable.a(oldKey);
        cqt.a builder = new cqt.a();
        builder.b(downfall);
        builder.a(temperature);
        boolean mojangPrecipitation = false;
        if (precipitation == Precipitation.RAIN) {
            mojangPrecipitation = true;
        } else if (precipitation == Precipitation.SNOW) {
            mojangPrecipitation = true;
        }
        builder.a(mojangPrecipitation);
        builder.a(forestbiome.b());
        builder.a(forestbiome.d());
        builder.a(cqt.d.a);
        cqz.a effects = new cqz.a();
        effects.b(waterColor == null ? forestbiome.i() : waterColor.intValue());
        effects.c(waterFogColor == null ? forestbiome.j() : waterFogColor.intValue());
        effects.a(fogColor == null ? forestbiome.e() : fogColor.intValue());
        effects.d(skyColor == null ? forestbiome.a() : skyColor.intValue());
        if (foliageColor != null) {
            effects.e(foliageColor.intValue());
        }
        if (grassColor != null) {
            effects.f(grassColor.intValue());
        }
        effects.a(cqr.b);
        cqz.b nativeGrassColorModifier = switch (grassColorModifier) {
            case BiomeUtils.GrassColorModifier.DARK_FOREST -> cqz.b.b;
            case BiomeUtils.GrassColorModifier.SWAMP -> cqz.b.c;
            default -> cqz.b.a;
        };
        effects.a(nativeGrassColorModifier);
        builder.a(effects.a());
        cqt newbiome = builder.a();
        registrywritable.f((Object)newbiome);
        he.c biomeHolder = registrywritable.a(newKey, (Object)newbiome, Lifecycle.stable());
        try {
            FIELD_MAPPED_REGISTRY_UNREGISTERED_INTRUSIVE_HOLDERS.set(registrywritable, null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        CustomBiomeImpl impl = new CustomBiomeImpl(id, (aev<cqt>)newKey, newbiome, (he.c<cqt>)biomeHolder);
        this.customBiomes.put(id, impl);
        this.customBiomesByBiome.put(newbiome, impl);
        return new CustomBiomeImpl(id, (aev<cqt>)newKey, newbiome, (he.c<cqt>)biomeHolder);
    }

    public Collection<? extends CustomBiome> getAllCustomBiomes() {
        return this.unmodifiableCustomBiomes;
    }

    public CustomBiome getCustomBiome(NamespacedKey id) {
        return this.customBiomes.get(id);
    }

    public CustomBiome getCustomBiomeAt(Location location) {
        he biomeHolder;
        dhq chunk;
        location.getWorld().getChunkAt(location);
        akq level = ((CraftWorld)location.getWorld()).getHandle();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        gw pos = new gw(x, 0, z);
        if (level.o(pos) && (chunk = level.l(pos)) != null && (biomeHolder = chunk.getNoiseBiome(x >> 2, y >> 2, z >> 2)).b()) {
            cqt biome = (cqt)biomeHolder.a();
            return this.customBiomesByBiome.get(biome);
        }
        return null;
    }
}

