/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_18_R1;

import com.destroystokyo.paper.entity.ai.VanillaGoal;
import de.cubeside.nmsutils.EntityUtils;
import de.cubeside.nmsutils.NMSUtils;
import de.cubeside.nmsutils.util.ReobfHelper;
import de.cubeside.nmsutils.v1_18_R1.NMSUtilsImpl;
import de.cubeside.nmsutils.v1_18_R1.PathfinderGoalLimitedRandomStrollLand;
import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftBat;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftRaider;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftVex;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftWolf;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Wolf;
import org.bukkit.util.Vector;

public class EntityUtilsImpl
implements EntityUtils {
    private static final Field FIELD_BAT_TARGET = ReobfHelper.getFieldByMojangName(bhg.class, (String)"targetPosition");
    private static final Field FIELD_ENTITY_TRACKER = ReobfHelper.getFieldByMojangName(awt.class, (String)"tracker");
    private final NMSUtilsImpl nmsUtils;

    public EntityUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    public void clearAI(Entity entity) {
        if (entity instanceof Mob) {
            this.nmsUtils.getPlugin().getServer().getMobGoals().removeAllGoals((Mob)entity);
        }
    }

    public void addGoalFloat(Mob mob) {
        if (!Bukkit.getMobGoals().hasGoal(mob, VanillaGoal.FLOAT)) {
            axj h = ((CraftMob)mob).getHandle();
            h.bR.a(1, (bdb)new bcv(h));
        }
    }

    public void addGoalLimitedStrollLand(Creature mob, double velocity, Function<Vector, Boolean> checkTargetFunction) {
        axq h = ((CraftCreature)mob).getHandle();
        h.bR.a(7, (bdb)new PathfinderGoalLimitedRandomStrollLand(h, velocity, checkTargetFunction));
    }

    public void removeGoalLimitedStrollLand(Creature mob) {
        axq h = ((CraftCreature)mob).getHandle();
        for (beo wrappedGoal : h.bR.c()) {
            bdb bdb2 = wrappedGoal.k();
            if (!(bdb2 instanceof PathfinderGoalLimitedRandomStrollLand)) continue;
            PathfinderGoalLimitedRandomStrollLand goal = (PathfinderGoalLimitedRandomStrollLand)bdb2;
            wrappedGoal.d();
            h.bR.a((bdb)goal);
            break;
        }
    }

    public int getShulkerOpenState(Entity shulker) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return 0;
            }
            CraftShulker cs = (CraftShulker)shulker;
            return cs.getHandle().fE();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get shulker open state", e);
            return 0;
        }
    }

    public void setShulkerOpenState(Entity shulker, int state) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return;
            }
            state = Math.max(0, Math.min(127, state));
            CraftShulker cs = (CraftShulker)shulker;
            cs.getHandle().a(state);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set shulker open state", e);
        }
    }

    public boolean isPiglinDancing(Entity piglin) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return false;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            return cs.getHandle().fF();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get piglin dancing state", e);
            return false;
        }
    }

    public void setPiglinDancing(Entity piglin, boolean dancing) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            cs.getHandle().w(dancing);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set piglin dancing state", e);
        }
    }

    public void sendEntityPositionUpdate(Entity entity) {
        awt handle = ((CraftEntity)entity).getHandle();
        try {
            acv.b ete = (acv.b)FIELD_ENTITY_TRACKER.get(handle);
            if (ete != null) {
                up positionPacket = new up(handle);
                ete.f.stream().forEach(viewer -> viewer.a((qr)positionPacket));
            }
        }
        catch (ReflectiveOperationException e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not send teleport packet", e);
        }
    }

    public void moveEntity(Entity e, double x, double y, double z) {
        awt handle = ((CraftEntity)e).getHandle();
        handle.a(axn.a, new dom(x, y, z));
    }

    public void moveEntity(Entity e, Vector v) {
        this.moveEntity(e, v.getX(), v.getY(), v.getZ());
    }

    public void setEntityHeadRotation(Entity e, float headRotation) {
        awt handle = ((CraftEntity)e).getHandle();
        if (handle instanceof axh) {
            ((axh)handle).ba = headRotation;
        } else {
            handle.l(headRotation);
        }
    }

    public float getEntityHeadRotation(Entity e) {
        awt handle = ((CraftEntity)e).getHandle();
        return handle.ce();
    }

    public void setEntityYaw(Entity e, float yaw) {
        awt handle = ((CraftEntity)e).getHandle();
        handle.o(yaw);
    }

    public float getEntityYaw(Entity e) {
        awt handle = ((CraftEntity)e).getHandle();
        return handle.dm();
    }

    public void setEntityPitch(Entity e, float pitch) {
        awt handle = ((CraftEntity)e).getHandle();
        handle.p(pitch);
    }

    public float getEntityPitch(Entity e) {
        awt handle = ((CraftEntity)e).getHandle();
        return handle.dn();
    }

    public void setEntityNavigationTarget(Entity entity, Location target, double speed) {
        if (entity instanceof Bat) {
            try {
                FIELD_BAT_TARGET.set(((CraftBat)entity).getHandle(), new gh(target.getX(), target.getY(), target.getZ()));
            }
            catch (ReflectiveOperationException e) {
                this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "could not set field", e);
            }
        } else if (entity instanceof Vex) {
            blz entityVex = ((CraftVex)entity).getHandle();
            entityVex.A().a(target.getX(), target.getY(), target.getZ(), speed);
            if (entityVex.G() == null) {
                entityVex.z().a(target.getX(), target.getY(), target.getZ(), 180.0f, 20.0f);
            }
        } else if (entity instanceof CraftMob) {
            ((CraftMob)entity).getHandle().D().a(target.getX(), target.getY(), target.getZ(), speed);
        } else {
            throw new IllegalArgumentException("Cannot set the navigation target for this mob");
        }
    }

    public void setEntityLeftHanded(Entity ent, boolean left) {
        awt nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof axj) {
            axj mob = (axj)nmsEntity;
            mob.t(left);
        }
    }

    public boolean isEntityLeftHanded(Entity ent) {
        awt nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof axj) {
            axj mob = (axj)nmsEntity;
            return mob.fs();
        }
        return false;
    }

    public boolean isEntityInvisible(Entity entity) {
        awt nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.bU();
    }

    public void setEntityInvisible(Entity entity, boolean invisible) {
        awt nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.j(invisible);
    }

    public boolean hasEntityNoClip(Entity entity) {
        awt nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.Q;
    }

    public void setEntityNoClip(Entity entity, boolean noClip) {
        awt nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.Q = noClip;
    }

    public boolean areChunkEntitiesLoaded(Chunk c) {
        return ((CraftWorld)c.getWorld()).getHandle().c(bzk.a((int)c.getX(), (int)c.getZ()));
    }

    public void loadChunkEntities(Chunk c) {
        int x = c.getX();
        int z = c.getZ();
        World world = c.getWorld();
        if (!world.isChunkLoaded(x, z)) {
            world.getChunkAt(x, z);
        }
        if (this.areChunkEntitiesLoaded(c)) {
            return;
        }
        adi serverLevel = ((CraftWorld)world).getHandle();
        serverLevel.P.a(new bzk(x, z), csb.b);
        if (!this.areChunkEntitiesLoaded(c)) {
            serverLevel.n().c(() -> {
                if (this.areChunkEntitiesLoaded(c)) {
                    return true;
                }
                serverLevel.P.a();
                return this.areChunkEntitiesLoaded(c);
            });
        }
    }

    public void setOnGround(Entity entity, boolean onGround) {
        awt nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.c(onGround);
    }

    public Entity getEntityById(World world, int id) {
        awt entity = ((CraftWorld)world).getHandle().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void setPose(Entity entity, Pose pose) {
        awt nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.b(axt.values()[pose.ordinal()]);
    }

    public void setWolfAngerTime(Wolf entity, int timeInTicks) {
        bim nmsEntity = ((CraftWolf)entity).getHandle();
        nmsEntity.a(timeInTicks);
    }

    public void setAggressive(Mob entity, boolean aggressive) {
        axj nmsEntity = ((CraftMob)entity).getHandle();
        nmsEntity.u(aggressive);
    }

    public boolean isAggressive(Mob entity) {
        axj nmsEntity = ((CraftMob)entity).getHandle();
        return nmsEntity.ft();
    }

    public boolean isCelebrating(Raider entity) {
        box nmsEntity = ((CraftRaider)entity).getHandle();
        return nmsEntity.fP();
    }

    public void setCelebrating(Raider entity, boolean celebrating) {
        box nmsEntity = ((CraftRaider)entity).getHandle();
        nmsEntity.z(celebrating);
    }
}

