/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_20_R1;

import com.google.common.base.Preconditions;
import de.cubeside.nmsutils.nbt.CompoundTag;
import de.cubeside.nmsutils.nbt.TagType;
import de.cubeside.nmsutils.v1_20_R1.ListTagImpl;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;

public final class CompoundTagImpl
implements CompoundTag {
    final NBTTagCompound handle;

    public CompoundTagImpl(NBTTagCompound handle) {
        this.handle = handle;
    }

    public boolean containsKey(String key) {
        return this.handle.e(key);
    }

    public boolean containsKey(String key, TagType type) {
        if (type == TagType.UUID) {
            return this.handle.b(key);
        }
        return this.handle.b(key, type.internalId());
    }

    public void clear() {
        this.handle.e().clear();
    }

    public void remove(String string) {
        this.handle.r(string);
    }

    public Set<String> getAllKeys() {
        return Collections.unmodifiableSet(this.handle.e());
    }

    public void size() {
        this.handle.f();
    }

    public CompoundTagImpl getCompound(String name) {
        return this.getCompound(name, false);
    }

    public CompoundTagImpl getCompound(String name, boolean createIfMissing) {
        Preconditions.checkNotNull((Object)name);
        NBTBase tag = this.handle.c(name);
        if (!(tag instanceof NBTTagCompound)) {
            if (!createIfMissing) {
                return null;
            }
            tag = new NBTTagCompound();
            this.handle.a(name, tag);
        }
        return new CompoundTagImpl((NBTTagCompound)tag);
    }

    public ListTagImpl getList(String name) {
        return this.getList(name, false);
    }

    public ListTagImpl getList(String name, boolean createIfMissing) {
        Preconditions.checkNotNull((Object)name);
        NBTBase tag = this.handle.c(name);
        if (!(tag instanceof NBTTagList)) {
            if (!createIfMissing) {
                return null;
            }
            tag = new NBTTagList();
            this.handle.a(name, tag);
        }
        return new ListTagImpl((NBTTagList)tag);
    }

    public byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    public byte getByte(String name, byte defaultValue) {
        NBTBase nBTBase = this.handle.c(name);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber tag = (NBTNumber)nBTBase;
            return tag.i();
        }
        return defaultValue;
    }

    public void setByte(String name, byte b) {
        Preconditions.checkNotNull((Object)name);
        this.handle.a(name, b);
    }

    public short getShort(String name) {
        return this.getShort(name, (short)0);
    }

    public short getShort(String name, short defaultValue) {
        NBTBase nBTBase = this.handle.c(name);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber tag = (NBTNumber)nBTBase;
            return tag.h();
        }
        return defaultValue;
    }

    public void setShort(String name, short s) {
        Preconditions.checkNotNull((Object)name);
        this.handle.a(name, s);
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int defaultValue) {
        NBTBase nBTBase = this.handle.c(name);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber tag = (NBTNumber)nBTBase;
            return tag.g();
        }
        return defaultValue;
    }

    public void setInt(String name, int v) {
        Preconditions.checkNotNull((Object)name);
        this.handle.a(name, v);
    }

    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    public long getLong(String name, long defaultValue) {
        NBTBase nBTBase = this.handle.c(name);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber tag = (NBTNumber)nBTBase;
            return tag.f();
        }
        return defaultValue;
    }

    public void setLong(String name, long l) {
        Preconditions.checkNotNull((Object)name);
        this.handle.a(name, l);
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public float getFloat(String name, float defaultValue) {
        NBTBase nBTBase = this.handle.c(name);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber tag = (NBTNumber)nBTBase;
            return tag.k();
        }
        return defaultValue;
    }

    public void setFloat(String name, float f) {
        Preconditions.checkNotNull((Object)name);
        this.handle.a(name, f);
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public double getDouble(String name, double defaultValue) {
        NBTBase nBTBase = this.handle.c(name);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber tag = (NBTNumber)nBTBase;
            return tag.j();
        }
        return defaultValue;
    }

    public void setDouble(String name, double d) {
        Preconditions.checkNotNull((Object)name);
        this.handle.a(name, d);
    }

    public byte[] getByteArray(String name) {
        return this.getByteArray(name, null);
    }

    public byte[] getByteArray(String name, byte[] defaultValue) {
        NBTBase nBTBase = this.handle.c(name);
        if (nBTBase instanceof NBTTagByteArray) {
            NBTTagByteArray tag = (NBTTagByteArray)nBTBase;
            return tag.e();
        }
        return defaultValue;
    }

    public void setByteArray(String name, byte[] b) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)b);
        this.handle.a(name, b);
    }

    public int[] getIntArray(String name) {
        return this.getIntArray(name, null);
    }

    public int[] getIntArray(String name, int[] defaultValue) {
        NBTBase nBTBase = this.handle.c(name);
        if (nBTBase instanceof NBTTagIntArray) {
            NBTTagIntArray tag = (NBTTagIntArray)nBTBase;
            return tag.g();
        }
        return defaultValue;
    }

    public void setIntArray(String name, int[] v) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)v);
        this.handle.a(name, v);
    }

    public long[] getLongArray(String name) {
        return this.getLongArray(name, null);
    }

    public long[] getLongArray(String name, long[] defaultValue) {
        NBTBase nBTBase = this.handle.c(name);
        if (nBTBase instanceof NBTTagLongArray) {
            NBTTagLongArray tag = (NBTTagLongArray)nBTBase;
            return tag.g();
        }
        return defaultValue;
    }

    public void setLongArray(String name, long[] v) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)v);
        this.handle.a(name, v);
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getString(String name, String defaultValue) {
        NBTBase nBTBase = this.handle.c(name);
        if (nBTBase instanceof NBTTagString) {
            NBTTagString tag = (NBTTagString)nBTBase;
            return tag.m_();
        }
        return defaultValue;
    }

    public void setString(String name, String v) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)v);
        this.handle.a(name, v);
    }

    public UUID getUUID(String name) {
        return this.handle.b(name) ? this.handle.a(name) : null;
    }

    public void setUUID(String name, UUID v) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)v);
        this.handle.a(name, v);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof CompoundTagImpl)) return false;
        CompoundTagImpl o = (CompoundTagImpl)obj;
        if (!this.handle.equals((Object)o.handle)) return false;
        return true;
    }
}

