/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_20_R1;

import de.cubeside.nmsutils.nbt.ByteArrayTag;
import de.cubeside.nmsutils.nbt.ByteTag;
import de.cubeside.nmsutils.nbt.CompoundTag;
import de.cubeside.nmsutils.nbt.DoubleTag;
import de.cubeside.nmsutils.nbt.FloatTag;
import de.cubeside.nmsutils.nbt.IntArrayTag;
import de.cubeside.nmsutils.nbt.IntTag;
import de.cubeside.nmsutils.nbt.ListTag;
import de.cubeside.nmsutils.nbt.LongArrayTag;
import de.cubeside.nmsutils.nbt.LongTag;
import de.cubeside.nmsutils.nbt.NbtUtils;
import de.cubeside.nmsutils.nbt.ShortTag;
import de.cubeside.nmsutils.nbt.StringTag;
import de.cubeside.nmsutils.nbt.Tag;
import de.cubeside.nmsutils.nbt.TagType;
import de.cubeside.nmsutils.v1_20_R1.NMSUtilsImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NbtUtilsImpl
implements NbtUtils {
    public NbtUtilsImpl(NMSUtilsImpl nmsUtils) {
    }

    @Override
    public CompoundTag parseBinary(byte[] in) {
        try {
            return this.fromNativeCompound(NBTCompressedStreamTools.a((DataInput)new DataInputStream(new ByteArrayInputStream(in))));
        }
        catch (IOException e) {
            throw new RuntimeException("invalid nbt");
        }
    }

    @Override
    public byte[] writeBinary(CompoundTag in) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            NBTCompressedStreamTools.a((NBTTagCompound)this.toNativeCompound(in), (DataOutput)new DataOutputStream(os));
        }
        catch (IOException e) {
            throw new RuntimeException("could not serialize nbt");
        }
        return os.toByteArray();
    }

    @Override
    public CompoundTag parseString(String in) {
        try {
            return this.fromNativeCompound(GameProfileSerializer.a((String)in));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse snbt string", e);
        }
    }

    @Override
    public String writeString(CompoundTag in) {
        return GameProfileSerializer.c((NBTTagCompound)this.toNativeCompound(in));
    }

    NBTTagCompound toNativeCompound(CompoundTag tag) {
        NBTTagCompound result = new NBTTagCompound();
        for (Map.Entry<String, Tag> e : tag.getValue().entrySet()) {
            Tag t = e.getValue();
            result.a(e.getKey(), (NBTBase)(switch (t.getType()) {
                case TagType.BYTE -> NBTTagByte.a((byte)((ByteTag)t).getValue());
                case TagType.BYTE_ARRAY -> new NBTTagByteArray(((ByteArrayTag)t).getValue());
                case TagType.COMPOUND -> this.toNativeCompound((CompoundTag)t);
                case TagType.DOUBLE -> NBTTagDouble.a((double)((DoubleTag)t).getValue());
                case TagType.FLOAT -> NBTTagFloat.a((float)((FloatTag)t).getValue());
                case TagType.INT -> NBTTagInt.a((int)((IntTag)t).getValue());
                case TagType.INT_ARRAY -> new NBTTagIntArray(((IntArrayTag)t).getValue());
                case TagType.LIST -> this.toNativeList((ListTag)t);
                case TagType.LONG -> NBTTagLong.a((long)((LongTag)t).getValue());
                case TagType.SHORT -> NBTTagShort.a((short)((ShortTag)t).getValue());
                case TagType.STRING -> NBTTagString.a((String)((StringTag)t).getValue());
                case TagType.LONG_ARRAY -> new NBTTagLongArray(((LongArrayTag)t).getValue());
                default -> throw new IllegalArgumentException("impossible?");
            }));
        }
        return result;
    }

    NBTTagList toNativeList(ListTag tag) {
        NBTTagList result = new NBTTagList();
        switch (tag.getListType()) {
            case BYTE: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)NBTTagByte.a((byte)((ByteTag)t).getValue()));
                }
                break;
            }
            case BYTE_ARRAY: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)new NBTTagByteArray(((ByteArrayTag)t).getValue()));
                }
                break;
            }
            case COMPOUND: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)this.toNativeCompound((CompoundTag)t));
                }
                break;
            }
            case DOUBLE: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)NBTTagDouble.a((double)((DoubleTag)t).getValue()));
                }
                break;
            }
            case FLOAT: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)NBTTagFloat.a((float)((FloatTag)t).getValue()));
                }
                break;
            }
            case INT: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)NBTTagInt.a((int)((IntTag)t).getValue()));
                }
                break;
            }
            case INT_ARRAY: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)new NBTTagIntArray(((IntArrayTag)t).getValue()));
                }
                break;
            }
            case LIST: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)this.toNativeList((ListTag)t));
                }
            }
            case LONG: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)NBTTagLong.a((long)((LongTag)t).getValue()));
                }
                break;
            }
            case SHORT: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)NBTTagShort.a((short)((ShortTag)t).getValue()));
                }
                break;
            }
            case STRING: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)NBTTagString.a((String)((StringTag)t).getValue()));
                }
                break;
            }
            case LONG_ARRAY: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)new NBTTagLongArray(((LongArrayTag)t).getValue()));
                }
                break;
            }
        }
        return result;
    }

    CompoundTag fromNativeCompound(NBTTagCompound tag) {
        HashMap<String, Tag> result = new HashMap<String, Tag>();
        for (String name : tag.e()) {
            NBTBase nativeTag = tag.c(name);
            switch (TagType.values()[nativeTag.b()]) {
                case BYTE: {
                    result.put(name, new ByteTag(((NBTTagByte)nativeTag).i()));
                    break;
                }
                case BYTE_ARRAY: {
                    result.put(name, new ByteArrayTag(((NBTTagByteArray)nativeTag).e()));
                    break;
                }
                case COMPOUND: {
                    result.put(name, this.fromNativeCompound((NBTTagCompound)nativeTag));
                    break;
                }
                case DOUBLE: {
                    result.put(name, new DoubleTag(((NBTTagDouble)nativeTag).j()));
                    break;
                }
                case FLOAT: {
                    result.put(name, new FloatTag(((NBTTagFloat)nativeTag).k()));
                    break;
                }
                case INT: {
                    result.put(name, new IntTag(((NBTTagInt)nativeTag).g()));
                    break;
                }
                case INT_ARRAY: {
                    result.put(name, new IntArrayTag(((NBTTagIntArray)nativeTag).g()));
                    break;
                }
                case LIST: {
                    result.put(name, this.fromNativeList((NBTTagList)nativeTag));
                    break;
                }
                case LONG: {
                    result.put(name, new LongTag(((NBTTagLong)nativeTag).f()));
                    break;
                }
                case SHORT: {
                    result.put(name, new ShortTag(((NBTTagShort)nativeTag).h()));
                    break;
                }
                case STRING: {
                    result.put(name, new StringTag(((NBTTagString)nativeTag).m_()));
                    break;
                }
                case LONG_ARRAY: {
                    result.put(name, new LongArrayTag(((NBTTagLongArray)nativeTag).g()));
                }
            }
        }
        return new CompoundTag(result);
    }

    ListTag fromNativeList(NBTTagList tag) {
        ListTag result = new ListTag();
        TagType type = TagType.values()[tag.f()];
        switch (type) {
            case BYTE: {
                tag.forEach(t -> result.addElement(new ByteTag(((NBTTagByte)t).i())));
                break;
            }
            case BYTE_ARRAY: {
                tag.forEach(t -> result.addElement(new ByteArrayTag(((NBTTagByteArray)t).e())));
                break;
            }
            case COMPOUND: {
                tag.forEach(t -> result.addElement(this.fromNativeCompound((NBTTagCompound)t)));
                break;
            }
            case DOUBLE: {
                tag.forEach(t -> result.addElement(new DoubleTag(((NBTTagDouble)t).j())));
                break;
            }
            case FLOAT: {
                tag.forEach(t -> result.addElement(new FloatTag(((NBTTagFloat)t).k())));
                break;
            }
            case INT: {
                tag.forEach(t -> result.addElement(new IntTag(((NBTTagInt)t).g())));
                break;
            }
            case INT_ARRAY: {
                tag.forEach(t -> result.addElement(new IntArrayTag(((NBTTagIntArray)t).g())));
                break;
            }
            case LIST: {
                tag.forEach(t -> result.addElement(this.fromNativeList((NBTTagList)t)));
                break;
            }
            case LONG: {
                tag.forEach(t -> result.addElement(new LongTag(((NBTTagLong)t).f())));
                break;
            }
            case SHORT: {
                tag.forEach(t -> result.addElement(new ShortTag(((NBTTagShort)t).h())));
                break;
            }
            case STRING: {
                tag.forEach(t -> result.addElement(new StringTag(((NBTTagString)t).m_())));
                break;
            }
            case LONG_ARRAY: {
                tag.forEach(t -> result.addElement(new LongArrayTag(((NBTTagLongArray)t).g())));
            }
        }
        return result;
    }
}

