/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_20_R1;

import de.cubeside.nmsutils.nbt.ByteArrayTag;
import de.cubeside.nmsutils.nbt.ByteTag;
import de.cubeside.nmsutils.nbt.CompoundTag;
import de.cubeside.nmsutils.nbt.DoubleTag;
import de.cubeside.nmsutils.nbt.FloatTag;
import de.cubeside.nmsutils.nbt.IntArrayTag;
import de.cubeside.nmsutils.nbt.IntTag;
import de.cubeside.nmsutils.nbt.ListTag;
import de.cubeside.nmsutils.nbt.LongArrayTag;
import de.cubeside.nmsutils.nbt.LongTag;
import de.cubeside.nmsutils.nbt.NbtUtils;
import de.cubeside.nmsutils.nbt.ShortTag;
import de.cubeside.nmsutils.nbt.StringTag;
import de.cubeside.nmsutils.nbt.Tag;
import de.cubeside.nmsutils.nbt.TagType;
import de.cubeside.nmsutils.v1_20_R1.NMSUtilsImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NbtUtilsImpl
implements NbtUtils {
    public NbtUtilsImpl(NMSUtilsImpl nmsUtils) {
    }

    public CompoundTag parseBinary(byte[] in) {
        try {
            return this.fromNativeCompound(rb.a((DataInput)new DataInputStream(new ByteArrayInputStream(in))));
        }
        catch (IOException e) {
            throw new RuntimeException("invalid nbt");
        }
    }

    public byte[] writeBinary(CompoundTag in) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            rb.a((qr)this.toNativeCompound(in), (DataOutput)new DataOutputStream(os));
        }
        catch (IOException e) {
            throw new RuntimeException("could not serialize nbt");
        }
        return os.toByteArray();
    }

    public CompoundTag parseString(String in) {
        try {
            return this.fromNativeCompound(rd.a((String)in));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse snbt string", e);
        }
    }

    public String writeString(CompoundTag in) {
        return rd.c((qr)this.toNativeCompound(in));
    }

    qr toNativeCompound(CompoundTag tag) {
        qr result = new qr();
        for (Map.Entry e : tag.getValue().entrySet()) {
            Tag t = (Tag)e.getValue();
            result.a((String)e.getKey(), (rk)(switch (t.getType()) {
                case TagType.BYTE -> qp.a((byte)((ByteTag)t).getValue());
                case TagType.BYTE_ARRAY -> new qo(((ByteArrayTag)t).getValue());
                case TagType.COMPOUND -> this.toNativeCompound((CompoundTag)t);
                case TagType.DOUBLE -> qs.a((double)((DoubleTag)t).getValue());
                case TagType.FLOAT -> qu.a((float)((FloatTag)t).getValue());
                case TagType.INT -> qw.a((int)((IntTag)t).getValue());
                case TagType.INT_ARRAY -> new qv(((IntArrayTag)t).getValue());
                case TagType.LIST -> this.toNativeList((ListTag)t);
                case TagType.LONG -> qz.a((long)((LongTag)t).getValue());
                case TagType.SHORT -> rf.a((short)((ShortTag)t).getValue());
                case TagType.STRING -> ri.a((String)((StringTag)t).getValue());
                case TagType.LONG_ARRAY -> new qy(((LongArrayTag)t).getValue());
                default -> throw new IllegalArgumentException("impossible?");
            }));
        }
        return result;
    }

    qx toNativeList(ListTag tag) {
        qx result = new qx();
        switch (tag.getListType()) {
            case BYTE: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)qp.a((byte)((ByteTag)t).getValue()));
                }
                break;
            }
            case BYTE_ARRAY: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)new qo(((ByteArrayTag)t).getValue()));
                }
                break;
            }
            case COMPOUND: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)this.toNativeCompound((CompoundTag)t));
                }
                break;
            }
            case DOUBLE: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)qs.a((double)((DoubleTag)t).getValue()));
                }
                break;
            }
            case FLOAT: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)qu.a((float)((FloatTag)t).getValue()));
                }
                break;
            }
            case INT: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)qw.a((int)((IntTag)t).getValue()));
                }
                break;
            }
            case INT_ARRAY: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)new qv(((IntArrayTag)t).getValue()));
                }
                break;
            }
            case LIST: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)this.toNativeList((ListTag)t));
                }
            }
            case LONG: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)qz.a((long)((LongTag)t).getValue()));
                }
                break;
            }
            case SHORT: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)rf.a((short)((ShortTag)t).getValue()));
                }
                break;
            }
            case STRING: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)ri.a((String)((StringTag)t).getValue()));
                }
                break;
            }
            case LONG_ARRAY: {
                for (Tag t : tag.getValue()) {
                    result.add((Object)new qy(((LongArrayTag)t).getValue()));
                }
                break;
            }
        }
        return result;
    }

    CompoundTag fromNativeCompound(qr tag) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String name : tag.e()) {
            rk nativeTag = tag.c(name);
            switch (TagType.values()[nativeTag.b()]) {
                case BYTE: {
                    result.put(name, new ByteTag(((qp)nativeTag).i()));
                    break;
                }
                case BYTE_ARRAY: {
                    result.put(name, new ByteArrayTag(((qo)nativeTag).e()));
                    break;
                }
                case COMPOUND: {
                    result.put(name, this.fromNativeCompound((qr)nativeTag));
                    break;
                }
                case DOUBLE: {
                    result.put(name, new DoubleTag(((qs)nativeTag).j()));
                    break;
                }
                case FLOAT: {
                    result.put(name, new FloatTag(((qu)nativeTag).k()));
                    break;
                }
                case INT: {
                    result.put(name, new IntTag(((qw)nativeTag).g()));
                    break;
                }
                case INT_ARRAY: {
                    result.put(name, new IntArrayTag(((qv)nativeTag).g()));
                    break;
                }
                case LIST: {
                    result.put(name, this.fromNativeList((qx)nativeTag));
                    break;
                }
                case LONG: {
                    result.put(name, new LongTag(((qz)nativeTag).f()));
                    break;
                }
                case SHORT: {
                    result.put(name, new ShortTag(((rf)nativeTag).h()));
                    break;
                }
                case STRING: {
                    result.put(name, new StringTag(((ri)nativeTag).m_()));
                    break;
                }
                case LONG_ARRAY: {
                    result.put(name, new LongArrayTag(((qy)nativeTag).g()));
                }
            }
        }
        return new CompoundTag(result);
    }

    ListTag fromNativeList(qx tag) {
        ListTag result = new ListTag();
        TagType type = TagType.values()[tag.f()];
        switch (type) {
            case BYTE: {
                tag.forEach(t -> result.addElement((Tag)new ByteTag(((qp)t).i())));
                break;
            }
            case BYTE_ARRAY: {
                tag.forEach(t -> result.addElement((Tag)new ByteArrayTag(((qo)t).e())));
                break;
            }
            case COMPOUND: {
                tag.forEach(t -> result.addElement((Tag)this.fromNativeCompound((qr)t)));
                break;
            }
            case DOUBLE: {
                tag.forEach(t -> result.addElement((Tag)new DoubleTag(((qs)t).j())));
                break;
            }
            case FLOAT: {
                tag.forEach(t -> result.addElement((Tag)new FloatTag(((qu)t).k())));
                break;
            }
            case INT: {
                tag.forEach(t -> result.addElement((Tag)new IntTag(((qw)t).g())));
                break;
            }
            case INT_ARRAY: {
                tag.forEach(t -> result.addElement((Tag)new IntArrayTag(((qv)t).g())));
                break;
            }
            case LIST: {
                tag.forEach(t -> result.addElement((Tag)this.fromNativeList((qx)t)));
                break;
            }
            case LONG: {
                tag.forEach(t -> result.addElement((Tag)new LongTag(((qz)t).f())));
                break;
            }
            case SHORT: {
                tag.forEach(t -> result.addElement((Tag)new ShortTag(((rf)t).h())));
                break;
            }
            case STRING: {
                tag.forEach(t -> result.addElement((Tag)new StringTag(((ri)t).m_())));
                break;
            }
            case LONG_ARRAY: {
                tag.forEach(t -> result.addElement((Tag)new LongArrayTag(((qy)t).g())));
            }
        }
        return result;
    }
}

