/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.nbt;

import com.google.common.base.Preconditions;
import de.cubeside.nmsutils.nbt.Tag;
import de.cubeside.nmsutils.nbt.TagType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ListTag
extends Tag {
    private final ArrayList<Tag> value = new ArrayList();
    private List<Tag> unmodifiableValue;

    public ListTag() {
    }

    public ListTag(Tag[] value) {
        if (value.length > 0) {
            TagType type = value[0].getType();
            this.value.add(value[0]);
            for (int i = 1; i < value.length; ++i) {
                if (value[i].getType() != type) {
                    throw new IllegalArgumentException("All list elements must have the same type.");
                }
                this.value.add(value[i]);
            }
        }
    }

    public int size() {
        return this.value.size();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public List<Tag> getValue() {
        if (this.unmodifiableValue == null) {
            this.unmodifiableValue = Collections.unmodifiableList(this.value);
        }
        return this.unmodifiableValue;
    }

    public TagType getListType() {
        return this.value.isEmpty() ? null : this.value.get(0).getType();
    }

    public Tag getElement(int i) {
        return this.value.get(i);
    }

    public Tag setElement(int i, Tag tag) {
        if (tag.getType() != this.getListType()) {
            throw new IllegalArgumentException("All list elements must have the same type.");
        }
        return this.value.set(i, tag);
    }

    public void addElement(Tag tag) {
        Preconditions.checkNotNull((Object)tag);
        if (!this.isEmpty() && tag.getType() != this.getListType()) {
            throw new IllegalArgumentException("All list elements must have the same type.");
        }
        this.value.add(tag);
    }

    public void addElement(int i, Tag tag) {
        Preconditions.checkNotNull((Object)tag);
        if (!(this.isEmpty() || i == 0 && this.size() == 1 || tag.getType() == this.getListType())) {
            throw new IllegalArgumentException("All list elements must have the same type.");
        }
        this.value.add(i, tag);
    }

    public Tag removeElement(int i) {
        return this.value.remove(i);
    }

    public void clearElements() {
        this.value.clear();
    }

    @Override
    public TagType getType() {
        return TagType.LIST;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ListTag)) return false;
        ListTag o = (ListTag)obj;
        if (!this.value.equals(o.value)) return false;
        return true;
    }
}

