/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.nbt;

import com.google.common.base.Preconditions;
import de.cubeside.nmsutils.nbt.ByteArrayTag;
import de.cubeside.nmsutils.nbt.ByteTag;
import de.cubeside.nmsutils.nbt.DoubleTag;
import de.cubeside.nmsutils.nbt.FloatTag;
import de.cubeside.nmsutils.nbt.IntArrayTag;
import de.cubeside.nmsutils.nbt.IntTag;
import de.cubeside.nmsutils.nbt.ListTag;
import de.cubeside.nmsutils.nbt.LongArrayTag;
import de.cubeside.nmsutils.nbt.LongTag;
import de.cubeside.nmsutils.nbt.NumericTag;
import de.cubeside.nmsutils.nbt.ShortTag;
import de.cubeside.nmsutils.nbt.StringTag;
import de.cubeside.nmsutils.nbt.Tag;
import de.cubeside.nmsutils.nbt.TagType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class CompoundTag
extends Tag {
    private final Map<String, Tag> value = new HashMap<String, Tag>();
    private Map<String, Tag> unmodifiableValue;

    public CompoundTag() {
    }

    public CompoundTag(Map<String, Tag> value) {
        for (Map.Entry<String, Tag> e : value.entrySet()) {
            String key = (String)Preconditions.checkNotNull((Object)e.getKey());
            Tag v = (Tag)Preconditions.checkNotNull((Object)e.getValue());
            this.value.put(key, v);
        }
    }

    public boolean containsKey(String key) {
        return this.value.containsKey(key);
    }

    public boolean containsKey(String key, TagType type) {
        Tag t = this.value.get(key);
        return t == null ? false : t.getType() == type;
    }

    public boolean containsNumeric(String key) {
        Tag entry = this.value.get(key);
        return entry instanceof NumericTag;
    }

    public int getNumericAsInt(String key) {
        Tag entry = this.value.get(key);
        if (!(entry instanceof NumericTag)) {
            throw new IllegalArgumentException("Tag is not numeric");
        }
        NumericTag t = (NumericTag)((Object)entry);
        return t.getValueAsInt();
    }

    public long getNumericAsLong(String key) {
        Tag entry = this.value.get(key);
        if (!(entry instanceof NumericTag)) {
            throw new IllegalArgumentException("Tag is not numeric");
        }
        NumericTag t = (NumericTag)((Object)entry);
        return t.getValueAsLong();
    }

    public double getNumericAsDouble(String key) {
        Tag entry = this.value.get(key);
        if (!(entry instanceof NumericTag)) {
            throw new IllegalArgumentException("Tag is not numeric");
        }
        NumericTag t = (NumericTag)((Object)entry);
        return t.getValueAsDouble();
    }

    public void clear() {
        this.value.clear();
    }

    public void remove(String string) {
        this.value.remove(string);
    }

    public Tag get(String name) {
        return this.value.get(name);
    }

    public CompoundTag getCompound(String name) {
        return (CompoundTag)this.value.get(name);
    }

    public CompoundTag setCompound(String name) {
        Preconditions.checkNotNull((Object)name);
        CompoundTag tag = new CompoundTag();
        this.setCompound(name, tag);
        return tag;
    }

    public void setCompound(String name, CompoundTag c) {
        Preconditions.checkNotNull((Object)name);
        this.value.put(name, c);
    }

    public ListTag getList(String name) {
        return (ListTag)this.value.get(name);
    }

    public ListTag setList(String name) {
        ListTag tag = new ListTag();
        this.setList(name, tag);
        return tag;
    }

    public void setList(String name, ListTag l) {
        Preconditions.checkNotNull((Object)name);
        this.value.put(name, l);
    }

    public byte getByte(String name) {
        ByteTag tag = (ByteTag)this.value.get(name);
        return tag == null ? (byte)0 : tag.getValue();
    }

    public byte getByte(String name, byte defaultValue) {
        byte by;
        Tag tag = this.value.get(name);
        if (tag instanceof ByteTag) {
            ByteTag t = (ByteTag)tag;
            by = t.getValue();
        } else {
            by = defaultValue;
        }
        return by;
    }

    public void setByte(String name, byte b) {
        Preconditions.checkNotNull((Object)name);
        this.value.put(name, new ByteTag(b));
    }

    public short getShort(String name) {
        ShortTag tag = (ShortTag)this.value.get(name);
        return tag == null ? (short)0 : tag.getValue();
    }

    public short getShort(String name, short defaultValue) {
        short s;
        Tag tag = this.value.get(name);
        if (tag instanceof ShortTag) {
            ShortTag t = (ShortTag)tag;
            s = t.getValue();
        } else {
            s = defaultValue;
        }
        return s;
    }

    public void setShort(String name, short s) {
        Preconditions.checkNotNull((Object)name);
        this.value.put(name, new ShortTag(s));
    }

    public int getInt(String name) {
        IntTag tag = (IntTag)this.value.get(name);
        return tag == null ? 0 : tag.getValue();
    }

    public int getInt(String name, int defaultValue) {
        int n;
        Tag tag = this.value.get(name);
        if (tag instanceof IntTag) {
            IntTag t = (IntTag)tag;
            n = t.getValue();
        } else {
            n = defaultValue;
        }
        return n;
    }

    public void setInt(String name, int v) {
        Preconditions.checkNotNull((Object)name);
        this.value.put(name, new IntTag(v));
    }

    public long getLong(String name) {
        LongTag tag = (LongTag)this.value.get(name);
        return tag == null ? 0L : tag.getValue();
    }

    public long getLong(String name, long defaultValue) {
        long l;
        Tag tag = this.value.get(name);
        if (tag instanceof LongTag) {
            LongTag t = (LongTag)tag;
            l = t.getValue();
        } else {
            l = defaultValue;
        }
        return l;
    }

    public void setLong(String name, long l) {
        Preconditions.checkNotNull((Object)name);
        this.value.put(name, new LongTag(l));
    }

    public float getFloat(String name) {
        FloatTag tag = (FloatTag)this.value.get(name);
        return tag == null ? 0.0f : tag.getValue();
    }

    public float getFloat(String name, float defaultValue) {
        float f;
        Tag tag = this.value.get(name);
        if (tag instanceof FloatTag) {
            FloatTag t = (FloatTag)tag;
            f = t.getValue();
        } else {
            f = defaultValue;
        }
        return f;
    }

    public void setFloat(String name, float f) {
        Preconditions.checkNotNull((Object)name);
        this.value.put(name, new FloatTag(f));
    }

    public double getDouble(String name) {
        DoubleTag tag = (DoubleTag)this.value.get(name);
        return tag == null ? 0.0 : tag.getValue();
    }

    public double getDouble(String name, double defaultValue) {
        double d;
        Tag tag = this.value.get(name);
        if (tag instanceof DoubleTag) {
            DoubleTag t = (DoubleTag)tag;
            d = t.getValue();
        } else {
            d = defaultValue;
        }
        return d;
    }

    public void setDouble(String name, double d) {
        Preconditions.checkNotNull((Object)name);
        this.value.put(name, new DoubleTag(d));
    }

    public byte[] getByteArray(String name) {
        ByteArrayTag tag = (ByteArrayTag)this.value.get(name);
        return tag == null ? null : tag.getValue();
    }

    public byte[] getByteArray(String name, byte[] defaultValue) {
        byte[] byArray;
        Tag tag = this.value.get(name);
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag t = (ByteArrayTag)tag;
            byArray = t.getValue();
        } else {
            byArray = defaultValue;
        }
        return byArray;
    }

    public void setByteArray(String name, byte[] b) {
        Preconditions.checkNotNull((Object)name);
        this.value.put(name, new ByteArrayTag(b));
    }

    public int[] getIntArray(String name) {
        IntArrayTag tag = (IntArrayTag)this.value.get(name);
        return tag == null ? null : tag.getValue();
    }

    public int[] getIntArray(String name, int[] defaultValue) {
        int[] nArray;
        Tag tag = this.value.get(name);
        if (tag instanceof IntArrayTag) {
            IntArrayTag t = (IntArrayTag)tag;
            nArray = t.getValue();
        } else {
            nArray = defaultValue;
        }
        return nArray;
    }

    public void setIntArray(String name, int[] v) {
        Preconditions.checkNotNull((Object)name);
        this.value.put(name, new IntArrayTag(v));
    }

    public long[] getLongArray(String name) {
        LongArrayTag tag = (LongArrayTag)this.value.get(name);
        return tag == null ? null : tag.getValue();
    }

    public long[] getLongArray(String name, long[] defaultValue) {
        long[] lArray;
        Tag tag = this.value.get(name);
        if (tag instanceof LongArrayTag) {
            LongArrayTag t = (LongArrayTag)tag;
            lArray = t.getValue();
        } else {
            lArray = defaultValue;
        }
        return lArray;
    }

    public void setLongArray(String name, long[] v) {
        Preconditions.checkNotNull((Object)name);
        this.value.put(name, new LongArrayTag(v));
    }

    public String getString(String name) {
        StringTag tag = (StringTag)this.value.get(name);
        return tag == null ? null : tag.getValue();
    }

    public String getString(String name, String defaultValue) {
        String string;
        Tag tag = this.value.get(name);
        if (tag instanceof StringTag) {
            StringTag t = (StringTag)tag;
            string = t.getValue();
        } else {
            string = defaultValue;
        }
        return string;
    }

    public void setString(String name, String v) {
        Preconditions.checkNotNull((Object)name);
        this.value.put(name, new StringTag(v));
    }

    public void setUUID(String name, UUID value) {
        long uuidMost = value.getMostSignificantBits();
        long uuidLeast = value.getLeastSignificantBits();
        this.setIntArray(name, new int[]{(int)(uuidMost >> 32), (int)uuidMost, (int)(uuidLeast >> 32), (int)uuidLeast});
    }

    public UUID getUUID(String name) {
        int[] array = this.getIntArray(name, null);
        if (array == null) {
            if (this.containsNumeric(name + "Most") && this.containsNumeric(name + "Least")) {
                return new UUID(this.getNumericAsLong(name + "Most"), this.getNumericAsLong(name + "Least"));
            }
        } else if (array.length == 4) {
            return new UUID((long)array[0] << 32 | (long)array[1] & 0xFFFFFFFFL, (long)array[2] << 32 | (long)array[3] & 0xFFFFFFFFL);
        }
        return null;
    }

    public boolean containsUUID(String name) {
        int[] array = this.getIntArray(name, null);
        if (array == null) {
            return this.containsNumeric(name + "Most") && this.containsNumeric(name + "Least");
        }
        return array.length == 4;
    }

    public Map<String, Tag> getValue() {
        if (this.unmodifiableValue == null) {
            this.unmodifiableValue = Collections.unmodifiableMap(this.value);
        }
        return this.unmodifiableValue;
    }

    @Override
    public TagType getType() {
        return TagType.COMPOUND;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof CompoundTag)) return false;
        CompoundTag o = (CompoundTag)obj;
        if (!this.value.equals(o.value)) return false;
        return true;
    }
}

