/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_19_R2;

import com.destroystokyo.paper.entity.ai.VanillaGoal;
import de.cubeside.nmsutils.EntityUtils;
import de.cubeside.nmsutils.NMSUtils;
import de.cubeside.nmsutils.util.ReobfHelper;
import de.cubeside.nmsutils.v1_19_R2.NMSUtilsImpl;
import de.cubeside.nmsutils.v1_19_R2.PathfinderGoalLimitedRandomStrollLand;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftBat;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftCamel;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftMob;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftRaider;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftVex;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftWolf;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Wolf;
import org.bukkit.util.Vector;

public class EntityUtilsImpl
implements EntityUtils {
    private static final Field FIELD_BAT_TARGET = ReobfHelper.getFieldByMojangName(bpj.class, (String)"targetPosition");
    private static final Field FIELD_ENTITY_TRACKER = ReobfHelper.getFieldByMojangName(bdr.class, (String)"tracker");
    private final NMSUtilsImpl nmsUtils;

    public EntityUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    public void clearAI(Entity entity) {
        if (entity instanceof Mob) {
            this.nmsUtils.getPlugin().getServer().getMobGoals().removeAllGoals((Mob)entity);
        }
    }

    public void addGoalFloat(Mob mob) {
        if (!Bukkit.getMobGoals().hasGoal(mob, VanillaGoal.FLOAT)) {
            bei h = ((CraftMob)mob).getHandle();
            h.bS.a(1, (bky)new bks(h));
        }
    }

    public void addGoalLimitedStrollLand(Creature mob, double velocity, Function<Vector, Boolean> checkTargetFunction) {
        bep h = ((CraftCreature)mob).getHandle();
        h.bS.a(7, (bky)new PathfinderGoalLimitedRandomStrollLand(h, velocity, checkTargetFunction));
    }

    public int getShulkerOpenState(Entity shulker) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return 0;
            }
            CraftShulker cs = (CraftShulker)shulker;
            return cs.getHandle().fT();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get shulker open state", e);
            return 0;
        }
    }

    public void setShulkerOpenState(Entity shulker, int state) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return;
            }
            state = Math.max(0, Math.min(127, state));
            CraftShulker cs = (CraftShulker)shulker;
            cs.getHandle().a(state);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set shulker open state", e);
        }
    }

    public boolean isPiglinDancing(Entity piglin) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return false;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            return cs.getHandle().fU();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get piglin dancing state", e);
            return false;
        }
    }

    public void setPiglinDancing(Entity piglin, boolean dancing) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            cs.getHandle().w(dancing);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set piglin dancing state", e);
        }
    }

    public void sendEntityPositionUpdate(Entity entity) {
        bdr handle = ((CraftEntity)entity).getHandle();
        try {
            agz.b ete = (agz.b)FIELD_ENTITY_TRACKER.get(handle);
            if (ete != null) {
                yh positionPacket = new yh(handle);
                ete.f.stream().forEach(viewer -> viewer.a((uh)positionPacket));
            }
        }
        catch (ReflectiveOperationException e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not send teleport packet", e);
        }
    }

    public void moveEntity(Entity e, double x, double y, double z) {
        bdr handle = ((CraftEntity)e).getHandle();
        handle.a(bem.a, new eae(x, y, z));
    }

    public void moveEntity(Entity e, Vector v) {
        this.moveEntity(e, v.getX(), v.getY(), v.getZ());
    }

    public void setEntityHeadRotation(Entity e, float headRotation) {
        bdr handle = ((CraftEntity)e).getHandle();
        if (handle instanceof beg) {
            ((beg)handle).aZ = headRotation;
        } else {
            handle.l(headRotation);
        }
    }

    public float getEntityHeadRotation(Entity e) {
        bdr handle = ((CraftEntity)e).getHandle();
        return handle.ck();
    }

    public void setEntityYaw(Entity e, float yaw) {
        bdr handle = ((CraftEntity)e).getHandle();
        handle.p(yaw);
    }

    public float getEntityYaw(Entity e) {
        bdr handle = ((CraftEntity)e).getHandle();
        return handle.dv();
    }

    public void setEntityPitch(Entity e, float pitch) {
        bdr handle = ((CraftEntity)e).getHandle();
        handle.q(pitch);
    }

    public float getEntityPitch(Entity e) {
        bdr handle = ((CraftEntity)e).getHandle();
        return handle.dx();
    }

    public void setEntityNavigationTarget(Entity entity, Location target, double speed) {
        if (entity instanceof Bat) {
            try {
                FIELD_BAT_TARGET.set(((CraftBat)entity).getHandle(), new gp(target.getX(), target.getY(), target.getZ()));
            }
            catch (ReflectiveOperationException e) {
                this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "could not set field", e);
            }
        } else if (entity instanceof Vex) {
            bur entityVex = ((CraftVex)entity).getHandle();
            entityVex.B().a(target.getX(), target.getY(), target.getZ(), speed);
            if (entityVex.H() == null) {
                entityVex.A().a(target.getX(), target.getY(), target.getZ(), 180.0f, 20.0f);
            }
        } else if (entity instanceof CraftMob) {
            ((CraftMob)entity).getHandle().E().a(target.getX(), target.getY(), target.getZ(), speed);
        } else {
            throw new IllegalArgumentException("Cannot set the navigation target for this mob: " + (Serializable)((Object)(entity == null ? "null" : entity.getType())));
        }
    }

    public void setEntityLeftHanded(Entity ent, boolean left) {
        bdr nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof bei) {
            bei mob = (bei)nmsEntity;
            mob.t(left);
        }
    }

    public boolean isEntityLeftHanded(Entity ent) {
        bdr nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof bei) {
            bei mob = (bei)nmsEntity;
            return mob.fF();
        }
        return false;
    }

    public boolean isEntityInvisible(Entity entity) {
        bdr nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.ca();
    }

    public void setEntityInvisible(Entity entity, boolean invisible) {
        bdr nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.j(invisible);
    }

    public boolean hasEntityNoClip(Entity entity) {
        bdr nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.Q;
    }

    public void setEntityNoClip(Entity entity, boolean noClip) {
        bdr nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.Q = noClip;
    }

    public boolean areChunkEntitiesLoaded(Chunk c) {
        return ((CraftWorld)c.getWorld()).getHandle().c(cjd.c((int)c.getX(), (int)c.getZ()));
    }

    public void loadChunkEntities(Chunk c) {
        this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Call to unimplemented method", new RuntimeException());
    }

    public void setOnGround(Entity entity, boolean onGround) {
        bdr nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.c(onGround);
    }

    public Entity getEntityById(World world, int id) {
        bdr entity = ((CraftWorld)world).getHandle().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void setPose(Entity entity, Pose pose) {
        bdr nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.b(bes.values()[pose.ordinal()]);
    }

    public void setWolfAngerTime(Wolf entity, int timeInTicks) {
        bqr nmsEntity = ((CraftWolf)entity).getHandle();
        nmsEntity.a(timeInTicks);
    }

    public void setAggressive(Mob entity, boolean aggressive) {
        bei nmsEntity = ((CraftMob)entity).getHandle();
        nmsEntity.u(aggressive);
    }

    public boolean isAggressive(Mob entity) {
        bei nmsEntity = ((CraftMob)entity).getHandle();
        return nmsEntity.fG();
    }

    public boolean isCelebrating(Raider entity) {
        bxx nmsEntity = ((CraftRaider)entity).getHandle();
        return nmsEntity.gd();
    }

    public void setCelebrating(Raider entity, boolean celebrating) {
        bxx nmsEntity = ((CraftRaider)entity).getHandle();
        nmsEntity.z(celebrating);
    }

    public void setCamelLastPoseChange(Camel entity, long tick) {
        bra nmsEntity = ((CraftCamel)entity).getHandle();
        nmsEntity.a(nmsEntity.Z().V() - tick);
    }

    public long getCamelLastPoseChange(Camel entity) {
        bra nmsEntity = ((CraftCamel)entity).getHandle();
        return nmsEntity.gb();
    }
}

