/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Modules;

import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Containers.AdminInventory;
import com.Acrobot.ChestShop.Events.PreTransactionEvent;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import com.Acrobot.ChestShop.Permission;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class DiscountModule
implements Listener {
    private YamlConfiguration config;
    private Set<String> groupList = new HashSet<String>();

    public DiscountModule() {
        this.config = YamlConfiguration.loadConfiguration((File)ChestShop.loadFile("discounts.yml"));
        this.config.options().setHeader(List.of("This file is for discount management. You are able to do that:", "group1: 75", "That means that the person with ChestShop.discount.group1 permission will pay only 75% of the price. ", "For example, if the price is 100 dollars, the player pays only 75 dollars.", "(Only works in buy-only Admin Shops!)"));
        try {
            this.config.save(ChestShop.loadFile("discounts.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.groupList = this.config.getKeys(false);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPreTransaction(PreTransactionEvent event) {
        if (event.isCancelled() || event.getTransactionType() != TransactionEvent.TransactionType.BUY || !(event.getOwnerInventory() instanceof AdminInventory)) {
            return;
        }
        Player client = event.getClient();
        if (!PriceUtil.hasBuyPrice(LegacyComponentSerializer.legacySection().serialize(event.getSign().getSide(Side.FRONT).line(2)))) {
            return;
        }
        for (String group : this.groupList) {
            if (!Permission.has((CommandSender)client, String.valueOf((Object)Permission.DISCOUNT) + group)) continue;
            event.setPrice(event.getPrice() * (this.config.getDouble(group) / 100.0));
            return;
        }
    }
}

