/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Commands;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Events.ItemInfoEvent;
import com.Acrobot.ChestShop.Utils.ItemNamingUtils;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;

public class ItemInfo
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof HumanEntity)) {
            return false;
        }
        ItemStack item = ((HumanEntity)sender).getInventory().getItemInMainHand();
        if (MaterialUtil.isEmpty(item)) {
            return false;
        }
        ItemInfo.showItemInfo(sender, item);
        return true;
    }

    public static void showItemInfo(CommandSender sender, ItemStack item) {
        sender.sendMessage(Messages.prefix(Messages.ITEM_INFO));
        if (MaterialUtil.isEmpty(item)) {
            sender.sendMessage("  " + String.valueOf(ChatColor.DARK_RED) + Messages.INCORRECT_ITEM_ID);
            return;
        }
        String displayName = ItemNamingUtils.getDisplayName(item);
        String fullName = ChatColor.stripColor((String)displayName);
        TextComponent tc = new TextComponent("  ");
        String typeName = item.getType().name();
        if (StringUtil.capitalizeFirstLetter(typeName, '_').equals(fullName)) {
            tc.addExtra((BaseComponent)new TranslatableComponent(item.translationKey(), new Object[0]));
            if (item.getType() == Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE) {
                tc.addExtra(" ");
                tc.addExtra((BaseComponent)new TranslatableComponent("upgrade.minecraft.netherite_upgrade", new Object[0]));
            } else if (typeName.endsWith("_SMITHING_TEMPLATE")) {
                String key = item.getType().getItemTranslationKey();
                key = key.replace("item.minecraft.", "").replace("_armor_trim_smithing_template", "");
                tc.addExtra(" ");
                tc.addExtra((BaseComponent)new TranslatableComponent("trim_pattern.minecraft." + key, new Object[0]));
            } else if (typeName.startsWith("MUSIC_DISC_") || typeName.endsWith("_BANNER_PATTERN")) {
                tc.addExtra(" ");
                tc.addExtra((BaseComponent)new TranslatableComponent(item.getType().translationKey() + ".desc", new Object[0]));
            }
        } else {
            tc.addExtra((BaseComponent)new TextComponent(fullName));
        }
        tc.setColor(net.md_5.bungee.api.ChatColor.WHITE);
        sender.spigot().sendMessage((BaseComponent)tc);
        ItemInfoEvent event = new ItemInfoEvent(sender, item);
        ChestShop.callEvent(event);
    }
}

