/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.ShopRemoval;

import com.Acrobot.Breeze.Utils.LocationUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Events.ShopDestroyedEvent;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ShopRemovalLogger
implements Listener {
    private static final String REMOVAL_MESSAGE = "%1$s was removed - %2$s - %3$s - at %4$s";

    @EventHandler(priority=EventPriority.MONITOR)
    public static void onShopRemoval(final ShopDestroyedEvent event) {
        if (event.getDestroyer() != null) {
            return;
        }
        ChestShop.getBukkitServer().getScheduler().runTaskAsynchronously((Plugin)ChestShop.getPlugin(), new Runnable(){

            @Override
            public void run() {
                String shopOwner = event.getSign().getLine(0);
                String typeOfShop = ChestShopSign.isAdminShop(shopOwner) ? "An Admin Shop" : "A shop belonging to " + shopOwner;
                String item = event.getSign().getLine(1) + ' ' + event.getSign().getLine(3);
                String prices = event.getSign().getLine(2);
                String location = LocationUtil.locationToString(event.getSign().getLocation());
                String message = String.format(ShopRemovalLogger.REMOVAL_MESSAGE, typeOfShop, item, prices, location);
                ChestShop.getBukkitLogger().info(message);
            }
        });
    }
}

