/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreTransaction;

import com.Acrobot.Breeze.Utils.InventoryUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Economy.Economy;
import com.Acrobot.ChestShop.Events.Economy.CurrencyAmountEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyCheckEvent;
import com.Acrobot.ChestShop.Events.Economy.CurrencyHoldEvent;
import com.Acrobot.ChestShop.Events.PreTransactionEvent;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PartialTransactionModule
implements Listener {
    @EventHandler(priority=EventPriority.LOW)
    public static void onPreBuyTransaction(PreTransactionEvent event) {
        if (event.isCancelled() || event.getTransactionType() != TransactionEvent.TransactionType.BUY) {
            return;
        }
        Player client = event.getClient();
        ItemStack[] stock = event.getStock();
        double price = event.getPrice();
        double pricePerItem = event.getPrice() / (double)InventoryUtil.countItems(stock);
        CurrencyAmountEvent currencyAmountEvent = new CurrencyAmountEvent(client);
        ChestShop.callEvent(currencyAmountEvent);
        BigDecimal walletMoney = currencyAmountEvent.getAmount();
        CurrencyCheckEvent currencyCheckEvent = new CurrencyCheckEvent(BigDecimal.valueOf(price), client);
        ChestShop.callEvent(currencyCheckEvent);
        if (!currencyCheckEvent.hasEnough()) {
            int amountAffordable = PartialTransactionModule.getAmountOfAffordableItems(walletMoney, pricePerItem);
            if (amountAffordable < 1) {
                event.setCancelled(PreTransactionEvent.TransactionOutcome.CLIENT_DOES_NOT_HAVE_ENOUGH_MONEY);
                return;
            }
            event.setPrice((double)amountAffordable * pricePerItem);
            event.setStock(PartialTransactionModule.getCountedItemStack(stock, amountAffordable));
        }
        UUID seller = event.getOwner().getUniqueId();
        CurrencyHoldEvent currencyHoldEvent = new CurrencyHoldEvent(BigDecimal.valueOf(price), seller, client.getWorld());
        ChestShop.callEvent(currencyHoldEvent);
        if (!currencyHoldEvent.canHold()) {
            event.setCancelled(PreTransactionEvent.TransactionOutcome.SHOP_DEPOSIT_FAILED);
            return;
        }
        stock = event.getStock();
        if (!InventoryUtil.hasItems(stock, event.getOwnerInventory())) {
            ItemStack[] itemsHad = PartialTransactionModule.getItems(stock, event.getOwnerInventory());
            int posessedItemCount = InventoryUtil.countItems(itemsHad);
            if (posessedItemCount <= 0) {
                event.setCancelled(PreTransactionEvent.TransactionOutcome.NOT_ENOUGH_STOCK_IN_CHEST);
                return;
            }
            event.setPrice(pricePerItem * (double)posessedItemCount);
            event.setStock(itemsHad);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public static void onPreSellTransaction(PreTransactionEvent event) {
        if (event.isCancelled() || event.getTransactionType() != TransactionEvent.TransactionType.SELL) {
            return;
        }
        Player client = event.getClient();
        UUID owner = event.getOwner().getUniqueId();
        ItemStack[] stock = event.getStock();
        double price = event.getPrice();
        double pricePerItem = event.getPrice() / (double)InventoryUtil.countItems(stock);
        CurrencyAmountEvent currencyAmountEvent = new CurrencyAmountEvent(owner, client.getWorld());
        ChestShop.callEvent(currencyAmountEvent);
        BigDecimal walletMoney = currencyAmountEvent.getAmount();
        if (Economy.isOwnerEconomicallyActive(event.getOwnerInventory())) {
            CurrencyCheckEvent currencyCheckEvent = new CurrencyCheckEvent(BigDecimal.valueOf(price), owner, client.getWorld());
            ChestShop.callEvent(currencyCheckEvent);
            if (!currencyCheckEvent.hasEnough()) {
                int amountAffordable = PartialTransactionModule.getAmountOfAffordableItems(walletMoney, pricePerItem);
                if (amountAffordable < 1) {
                    event.setCancelled(PreTransactionEvent.TransactionOutcome.SHOP_DOES_NOT_HAVE_ENOUGH_MONEY);
                    return;
                }
                event.setPrice((double)amountAffordable * pricePerItem);
                event.setStock(PartialTransactionModule.getCountedItemStack(stock, amountAffordable));
            }
        }
        stock = event.getStock();
        CurrencyHoldEvent currencyHoldEvent = new CurrencyHoldEvent(BigDecimal.valueOf(price), client);
        ChestShop.callEvent(currencyHoldEvent);
        if (!currencyHoldEvent.canHold()) {
            event.setCancelled(PreTransactionEvent.TransactionOutcome.CLIENT_DEPOSIT_FAILED);
            return;
        }
        if (!InventoryUtil.hasItems(stock, event.getClientInventory())) {
            ItemStack[] itemsHad = PartialTransactionModule.getItems(stock, event.getClientInventory());
            int posessedItemCount = InventoryUtil.countItems(itemsHad);
            if (posessedItemCount <= 0) {
                event.setCancelled(PreTransactionEvent.TransactionOutcome.NOT_ENOUGH_STOCK_IN_INVENTORY);
                return;
            }
            event.setPrice(pricePerItem * (double)posessedItemCount);
            event.setStock(itemsHad);
        }
    }

    private static int getAmountOfAffordableItems(BigDecimal walletMoney, double pricePerItem) {
        return (int)Math.floor(walletMoney.doubleValue() / pricePerItem);
    }

    private static ItemStack[] getItems(ItemStack[] stock, Inventory inventory) {
        ItemStack[] neededItems;
        LinkedList<ItemStack> toReturn = new LinkedList<ItemStack>();
        for (ItemStack item : neededItems = InventoryUtil.mergeSimilarStacks(stock)) {
            int amount = InventoryUtil.getAmount(item, inventory);
            ItemStack clone = item.clone();
            clone.setAmount(amount > item.getAmount() ? item.getAmount() : amount);
            toReturn.add(clone);
        }
        return toReturn.toArray(new ItemStack[toReturn.size()]);
    }

    private static ItemStack[] getCountedItemStack(ItemStack[] stock, int numberOfItems) {
        int left = numberOfItems;
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
        for (ItemStack stack : stock) {
            ItemStack toAdd;
            int count = stack.getAmount();
            if (left > count) {
                toAdd = stack;
                left -= count;
            } else {
                ItemStack clone = stack.clone();
                clone.setAmount(left);
                toAdd = clone;
                left = 0;
            }
            boolean added = false;
            for (ItemStack iStack : stacks) {
                if (!toAdd.isSimilar(iStack)) continue;
                iStack.setAmount(iStack.getAmount() + toAdd.getAmount());
                added = true;
                break;
            }
            if (!added) {
                stacks.add(toAdd);
            }
            if (left <= 0) break;
        }
        return stacks.toArray(new ItemStack[stacks.size()]);
    }
}

