/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.ORMlite.field;

import com.Acrobot.ChestShop.ORMlite.field.DataPersister;
import com.Acrobot.ChestShop.ORMlite.field.DataType;
import com.Acrobot.ChestShop.ORMlite.field.types.EnumStringType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataPersisterManager {
    private static final DataPersister DEFAULT_ENUM_PERSISTER = EnumStringType.getSingleton();
    private static final Map<String, DataPersister> builtInMap;
    private static List<DataPersister> registeredPersisters;

    private DataPersisterManager() {
    }

    public static void registerDataPersisters(DataPersister ... dataPersisters) {
        ArrayList<DataPersister> newList = new ArrayList<DataPersister>();
        if (registeredPersisters != null) {
            newList.addAll(registeredPersisters);
        }
        for (DataPersister persister : dataPersisters) {
            newList.add(persister);
        }
        registeredPersisters = newList;
    }

    public static void clear() {
        registeredPersisters = null;
    }

    public static DataPersister lookupForField(Field field) {
        DataPersister dataPersister;
        if (registeredPersisters != null) {
            for (DataPersister persister : registeredPersisters) {
                if (persister.isValidForField(field)) {
                    return persister;
                }
                for (Class<?> clazz : persister.getAssociatedClasses()) {
                    if (field.getType() != clazz) continue;
                    return persister;
                }
            }
        }
        if ((dataPersister = builtInMap.get(field.getType().getName())) != null) {
            return dataPersister;
        }
        if (field.getType().isEnum()) {
            return DEFAULT_ENUM_PERSISTER;
        }
        return null;
    }

    static {
        registeredPersisters = null;
        builtInMap = new HashMap<String, DataPersister>();
        for (DataType dataType : DataType.values()) {
            DataPersister persister = dataType.getDataPersister();
            if (persister == null) continue;
            for (Class<?> clazz : persister.getAssociatedClasses()) {
                builtInMap.put(clazz.getName(), persister);
            }
            String[] associatedClassNames = persister.getAssociatedClassNames();
            if (associatedClassNames == null) continue;
            for (String className : persister.getAssociatedClassNames()) {
                builtInMap.put(className, persister);
            }
        }
    }
}

