/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Utils;

import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Events.PreShopCreationItemDisplayNameEvent;
import com.Acrobot.ChestShop.ItemNaming.ChestShopItemDisplayNameShortener;
import com.Acrobot.ChestShop.ItemNaming.ItemDisplayNameShortener;
import java.io.Serializable;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemNamingUtils {
    private static final ItemDisplayNameShortener CHEST_SHOP_ITEM_DISPLAY_NAME_SHORTENER = new ChestShopItemDisplayNameShortener();

    public static String getSignItemName(ItemStack itemStack) {
        return ItemNamingUtils.getDisplayName(itemStack, 15);
    }

    public static String getDisplayName(ItemStack itemStack) {
        return ItemNamingUtils.getDisplayName(itemStack, Integer.MAX_VALUE);
    }

    public static String getDisplayName(ItemStack itemStack, int length) {
        ItemMeta itemMeta;
        if (itemStack == null) {
            return null;
        }
        String itemName = StringUtil.capitalizeFirstLetter(itemStack.getType().name(), '_');
        boolean needsItalicEffect = false;
        if (itemStack.hasItemMeta() && !(itemMeta = itemStack.getItemMeta()).equals(new ItemStack(itemStack.getType()).getItemMeta())) {
            needsItalicEffect = true;
        }
        PreShopCreationItemDisplayNameEvent preShopCreationItemDisplayNameEvent = new PreShopCreationItemDisplayNameEvent(itemStack, itemName);
        ChestShop.callEvent(preShopCreationItemDisplayNameEvent);
        itemName = preShopCreationItemDisplayNameEvent.getDisplayName();
        ItemDisplayNameShortener itemDisplayNameShortener = preShopCreationItemDisplayNameEvent.getItemDisplayNameShortener();
        itemName = ItemNamingUtils.shortenDisplayName(itemName, length, itemDisplayNameShortener);
        return (Serializable)(needsItalicEffect ? ChatColor.ITALIC : "") + itemName.substring(0, Math.min(itemName.length(), length));
    }

    public static String shortenDisplayName(String name, int length) {
        return ItemNamingUtils.shortenDisplayName(name, length, null);
    }

    public static String shortenDisplayName(String name, int length, ItemDisplayNameShortener customItemDisplayNameShortener) {
        String result = name.toLowerCase();
        if (result.length() <= length) {
            return name;
        }
        if (customItemDisplayNameShortener != null && (result = customItemDisplayNameShortener.shorten(result, length)).length() <= length) {
            return result;
        }
        if ((result = CHEST_SHOP_ITEM_DISPLAY_NAME_SHORTENER.shorten(result, length)).length() <= length) {
            return result;
        }
        String[] split = result.split(" ");
        int remainingLetters = length;
        StringBuilder cutdown = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String currentWord = split[i];
            int remainingWords = split.length - i;
            int wordLength = remainingLetters / remainingWords;
            int rest = remainingLetters % remainingWords;
            int newLength = wordLength + (0 < rest ? 1 : 0);
            if (currentWord.length() < newLength) {
                int currentWordLength;
                newLength = currentWordLength = currentWord.length();
            }
            remainingLetters -= newLength;
            String substring = currentWord.substring(0, newLength);
            String capitalized = StringUtil.capitalizeFirstLetter(substring);
            cutdown.append(capitalized);
        }
        return cutdown.substring(0, Math.min(cutdown.length(), length));
    }
}

