/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.ORMlite.stmt.mapped;

import com.Acrobot.ChestShop.ORMlite.dao.ObjectCache;
import com.Acrobot.ChestShop.ORMlite.db.DatabaseType;
import com.Acrobot.ChestShop.ORMlite.field.FieldType;
import com.Acrobot.ChestShop.ORMlite.misc.SqlExceptionUtil;
import com.Acrobot.ChestShop.ORMlite.stmt.mapped.BaseMappedStatement;
import com.Acrobot.ChestShop.ORMlite.support.DatabaseConnection;
import com.Acrobot.ChestShop.ORMlite.table.TableInfo;
import java.sql.SQLException;
import java.util.Collection;

public class MappedDeleteCollection<T, ID>
extends BaseMappedStatement<T, ID> {
    private MappedDeleteCollection(TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes) {
        super(tableInfo, statement, argFieldTypes);
    }

    public static <T, ID> int deleteObjects(DatabaseType databaseType, TableInfo<T, ID> tableInfo, DatabaseConnection databaseConnection, Collection<T> datas, ObjectCache objectCache) throws SQLException {
        MappedDeleteCollection<T, ID> deleteCollection = MappedDeleteCollection.build(databaseType, tableInfo, datas.size());
        Object[] fieldObjects = new Object[datas.size()];
        FieldType idField = tableInfo.getIdField();
        int objC = 0;
        for (T data : datas) {
            fieldObjects[objC] = idField.extractJavaFieldToSqlArgValue(data);
            ++objC;
        }
        return MappedDeleteCollection.updateRows(databaseConnection, tableInfo.getDataClass(), deleteCollection, fieldObjects, objectCache);
    }

    public static <T, ID> int deleteIds(DatabaseType databaseType, TableInfo<T, ID> tableInfo, DatabaseConnection databaseConnection, Collection<ID> ids, ObjectCache objectCache) throws SQLException {
        MappedDeleteCollection<T, ID> deleteCollection = MappedDeleteCollection.build(databaseType, tableInfo, ids.size());
        Object[] fieldObjects = new Object[ids.size()];
        FieldType idField = tableInfo.getIdField();
        int objC = 0;
        for (ID id : ids) {
            fieldObjects[objC] = idField.convertJavaFieldToSqlArgValue(id);
            ++objC;
        }
        return MappedDeleteCollection.updateRows(databaseConnection, tableInfo.getDataClass(), deleteCollection, fieldObjects, objectCache);
    }

    private static <T, ID> MappedDeleteCollection<T, ID> build(DatabaseType databaseType, TableInfo<T, ID> tableInfo, int dataSize) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot delete " + tableInfo.getDataClass() + " because it doesn't have an id field defined");
        }
        StringBuilder sb = new StringBuilder(128);
        MappedDeleteCollection.appendTableName(databaseType, sb, "DELETE FROM ", tableInfo.getTableName());
        FieldType[] argFieldTypes = new FieldType[dataSize];
        MappedDeleteCollection.appendWhereIds(databaseType, idField, sb, dataSize, argFieldTypes);
        return new MappedDeleteCollection<T, ID>(tableInfo, sb.toString(), argFieldTypes);
    }

    private static <T, ID> int updateRows(DatabaseConnection databaseConnection, Class<T> clazz, MappedDeleteCollection<T, ID> deleteCollection, Object[] args, ObjectCache objectCache) throws SQLException {
        try {
            int rowC = databaseConnection.delete(deleteCollection.statement, args, deleteCollection.argFieldTypes);
            if (rowC > 0 && objectCache != null) {
                for (Object id : args) {
                    objectCache.remove(clazz, id);
                }
            }
            logger.debug("delete-collection with statement '{}' and {} args, changed {} rows", (Object)deleteCollection.statement, (Object)args.length, (Object)rowC);
            if (args.length > 0) {
                logger.trace("delete-collection arguments: {}", (Object)args);
            }
            return rowC;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Unable to run delete collection stmt: " + deleteCollection.statement, e);
        }
    }

    private static void appendWhereIds(DatabaseType databaseType, FieldType idField, StringBuilder sb, int numDatas, FieldType[] fieldTypes) {
        sb.append("WHERE ");
        databaseType.appendEscapedEntityName(sb, idField.getColumnName());
        sb.append(" IN (");
        boolean first = true;
        for (int i = 0; i < numDatas; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append('?');
            if (fieldTypes == null) continue;
            fieldTypes[i] = idField;
        }
        sb.append(") ");
    }
}

