/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners;

import com.Acrobot.Breeze.Utils.EnchantmentNames;
import com.Acrobot.Breeze.Utils.FireworkEffectTypeNames;
import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.Breeze.Utils.PotionNames;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.Events.ItemInfoEvent;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;

public class ItemInfoListener
implements Listener {
    @EventHandler
    public static void addInfo(ItemInfoEvent event) {
        List lore;
        LeatherArmorMeta leatherArmorMeta;
        Color color;
        TropicalFishBucketMeta tropicalFishBucketMeta;
        BlockState blockState;
        BlockStateMeta blockStateMeta;
        String string;
        SkullMeta skull;
        FireworkEffectMeta fireworkEffect;
        EnchantmentStorageMeta ench;
        Repairable repairable;
        short maxdurability;
        CommandSender sender = event.getSender();
        ItemStack item = event.getItem();
        Material type = item.getType();
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName() && !(meta instanceof BookMeta)) {
            sender.sendMessage("    " + ChatColor.GRAY + "Name: " + meta.getDisplayName());
        }
        if ((maxdurability = type.getMaxDurability()) > 0 && meta instanceof Damageable) {
            int remainingDurability = maxdurability - ((Damageable)meta).getDamage();
            sender.sendMessage("    " + ChatColor.RED + "Durability: " + remainingDurability + "/" + maxdurability);
        }
        if (meta instanceof Repairable && (repairable = (Repairable)meta).hasRepairCost()) {
            sender.sendMessage("    " + ChatColor.RED + "Additional Repair Cost: " + repairable.getRepairCost());
        }
        if (meta instanceof BookMeta) {
            BookMeta book = (BookMeta)meta;
            if (meta.hasDisplayName()) {
                sender.sendMessage("    " + ChatColor.GRAY + "Title: " + meta.getDisplayName());
            } else if (book.hasTitle()) {
                sender.sendMessage("    " + ChatColor.GRAY + "Title: " + book.getTitle());
            }
            if (book.hasAuthor()) {
                sender.sendMessage("    " + ChatColor.GRAY + "Author: " + book.getAuthor());
            }
            if (book.hasGeneration() && book.getGeneration() != BookMeta.Generation.ORIGINAL) {
                sender.sendMessage("    " + ChatColor.RED + StringUtil.capitalizeFirstLetter(book.getGeneration().name(), '_'));
            }
        }
        Map enchantments = item.getEnchantments();
        for (Map.Entry entry : enchantments.entrySet()) {
            sender.sendMessage("    " + ChatColor.GRAY + EnchantmentNames.getName((Enchantment)entry.getKey()) + ' ' + NumberUtil.toRoman((Integer)entry.getValue()));
        }
        if (meta instanceof EnchantmentStorageMeta && (ench = (EnchantmentStorageMeta)meta).hasStoredEnchants()) {
            for (Map.Entry entry : ench.getStoredEnchants().entrySet()) {
                sender.sendMessage("    " + ChatColor.GRAY + EnchantmentNames.getName((Enchantment)entry.getKey()) + ' ' + NumberUtil.toRoman((Integer)entry.getValue()));
            }
        }
        if (meta instanceof FireworkMeta) {
            FireworkMeta firework = (FireworkMeta)meta;
            sender.sendMessage("    " + ChatColor.GRAY + "Flight Duration: " + firework.getPower());
            for (FireworkEffect fireworkEffect2 : firework.getEffects()) {
                ItemInfoListener.sendFireworkEffect(sender, fireworkEffect2);
            }
        }
        if (meta instanceof FireworkEffectMeta && (fireworkEffect = (FireworkEffectMeta)meta).hasEffect()) {
            FireworkEffect fireworkEffect3 = fireworkEffect.getEffect();
            ItemInfoListener.sendFireworkEffect(sender, fireworkEffect3);
        }
        if (meta instanceof SkullMeta && (skull = (SkullMeta)meta).hasOwner() && (string = skull.getOwner()) != null) {
            sender.sendMessage("    " + ChatColor.GRAY + "Skull Owner: " + string);
        }
        if (meta instanceof PotionMeta) {
            PotionMeta potion = (PotionMeta)meta;
            StringBuilder stringBuilder = new StringBuilder(50).append("    ").append(ChatColor.GRAY);
            PotionData potionData = potion.getBasePotionData();
            if (potionData != null) {
                if (potionData.isExtended()) {
                    stringBuilder.append("Extended ");
                }
                if (type == Material.SPLASH_POTION) {
                    stringBuilder.append("Splash ");
                }
                if (type == Material.LINGERING_POTION) {
                    stringBuilder.append("Lingering ");
                }
                stringBuilder.append(PotionNames.getName(potionData.getType())).append(' ');
                if (potionData.isUpgraded()) {
                    stringBuilder.append("II ");
                }
                sender.sendMessage(stringBuilder.toString());
            }
            if (potion.hasCustomEffects()) {
                for (PotionEffect effect : potion.getCustomEffects()) {
                    sender.sendMessage("    " + ChatColor.GRAY + StringUtil.capitalizeFirstLetter(effect.getType().getName(), '_') + ' ' + NumberUtil.toTime(effect.getDuration() / 20));
                }
            }
        }
        if (meta instanceof BlockStateMeta && (blockStateMeta = (BlockStateMeta)meta).hasBlockState() && (blockState = blockStateMeta.getBlockState()) != null && blockState instanceof Container) {
            Inventory inventory = ((Container)blockState).getInventory();
            int stacks = 0;
            for (ItemStack stack : inventory.getContents()) {
                if (stack == null || stack.getType() == Material.AIR) continue;
                ++stacks;
            }
            if (stacks > 0) {
                sender.sendMessage("    " + ChatColor.GRAY + "Content: " + stacks + " Stacks");
            }
        }
        if (meta instanceof TropicalFishBucketMeta && (tropicalFishBucketMeta = (TropicalFishBucketMeta)meta).hasVariant()) {
            String string2 = StringUtil.capitalizeFirstLetter(Objects.toString(tropicalFishBucketMeta.getPattern()), '_');
            String string3 = StringUtil.capitalizeFirstLetter(Objects.toString(tropicalFishBucketMeta.getBodyColor()), '_');
            String patterncolor = StringUtil.capitalizeFirstLetter(Objects.toString(tropicalFishBucketMeta.getPatternColor()), '_');
            sender.sendMessage("    " + ChatColor.GRAY + "Variant: " + string2 + " " + string3 + "/" + patterncolor);
        }
        if (meta instanceof LeatherArmorMeta && (color = (leatherArmorMeta = (LeatherArmorMeta)meta).getColor()) != null) {
            sender.sendMessage("    " + ChatColor.GRAY + "Color: " + ItemInfoListener.getColorHexCode(color));
        }
        if (meta != null && meta.hasLore() && !(meta instanceof BookMeta) && (lore = meta.getLore()) != null && lore.size() > 0) {
            if (lore.size() == 1) {
                sender.sendMessage("    " + ChatColor.GRAY + "Lore: " + (String)lore.get(0));
            } else {
                sender.sendMessage("    " + ChatColor.GRAY + "Lore:");
                for (String string4 : lore) {
                    sender.sendMessage("      " + ChatColor.GRAY + string4);
                }
            }
        }
    }

    private static void sendFireworkEffect(CommandSender sender, FireworkEffect effect) {
        sender.sendMessage("    " + ChatColor.GRAY + FireworkEffectTypeNames.getName(effect.getType()));
        List colors = effect.getColors();
        if (colors != null && !colors.isEmpty()) {
            sender.sendMessage("      " + ChatColor.GRAY + ItemInfoListener.colorListToString(colors));
        }
        if ((colors = effect.getFadeColors()) != null && !colors.isEmpty()) {
            sender.sendMessage("      " + ChatColor.GRAY + "Fade to " + ItemInfoListener.colorListToString(colors));
        }
        if (effect.hasTrail()) {
            sender.sendMessage("      " + ChatColor.GRAY + "Trail");
        }
        if (effect.hasFlicker()) {
            sender.sendMessage("      " + ChatColor.GRAY + "Twinkle");
        }
    }

    private static String colorListToString(List<Color> colors) {
        StringBuilder sb = new StringBuilder();
        for (Color c : colors) {
            DyeColor dyeColor;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append((dyeColor = DyeColor.getByFireworkColor((Color)c)) != null ? StringUtil.capitalizeFirstLetter(dyeColor.name(), '_') : "Custom");
        }
        return sb.toString();
    }

    private static String getTwoCharacterColorHexCode(int color) {
        String s = Integer.toHexString(color).toUpperCase();
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    private static String getColorHexCode(Color color) {
        String red = ItemInfoListener.getTwoCharacterColorHexCode(color.getRed());
        String green = ItemInfoListener.getTwoCharacterColorHexCode(color.getGreen());
        String blue = ItemInfoListener.getTwoCharacterColorHexCode(color.getBlue());
        return "#" + red + green + blue;
    }
}

