/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.javax.persistence;

import com.Acrobot.ChestShop.javax.persistence.EntityManagerFactory;
import com.Acrobot.ChestShop.javax.persistence.PersistenceException;
import com.Acrobot.ChestShop.javax.persistence.spi.PersistenceProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Persistence {
    public static String PERSISTENCE_PROVIDER = "com.Acrobot.ChestShop.javax.persistence.spi.PeristenceProvider";
    protected static final Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName) {
        return Persistence.createEntityManagerFactory(persistenceUnitName, null);
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        PersistenceProvider provider;
        EntityManagerFactory emf = null;
        if (providers.size() == 0) {
            try {
                Persistence.findAllProviders();
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
        Iterator<PersistenceProvider> i$ = providers.iterator();
        while (i$.hasNext() && (emf = (provider = i$.next()).createEntityManagerFactory(persistenceUnitName, properties)) == null) {
        }
        if (emf == null) {
            throw new PersistenceException("No Persistence provider for EntityManager named " + persistenceUnitName);
        }
        return emf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findAllProviders() throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = loader.getResources("META-INF/services/" + PersistenceProvider.class.getName());
        HashSet<String> names = new HashSet<String>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            InputStream is = url.openStream();
            try {
                names.addAll(Persistence.providerNamesFromReader(new BufferedReader(new InputStreamReader(is))));
            }
            finally {
                is.close();
            }
        }
        for (String s : names) {
            try {
                providers.add((PersistenceProvider)loader.loadClass(s).newInstance());
            }
            catch (ClassNotFoundException exc) {
            }
            catch (InstantiationException exc) {
            }
            catch (IllegalAccessException exc) {}
        }
    }

    private static Set<String> providerNamesFromReader(BufferedReader reader) throws IOException {
        String line;
        HashSet<String> names = new HashSet<String>();
        while ((line = reader.readLine()) != null) {
            Matcher m = nonCommentPattern.matcher(line = line.trim());
            if (!m.find()) continue;
            names.add(m.group().trim());
        }
        return names;
    }
}

