/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop;

import com.Acrobot.Breeze.Configuration.Configuration;
import com.Acrobot.ChestShop.Commands.Give;
import com.Acrobot.ChestShop.Commands.ItemInfo;
import com.Acrobot.ChestShop.Commands.Toggle;
import com.Acrobot.ChestShop.Commands.Version;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Database.Migrations;
import com.Acrobot.ChestShop.Dependencies;
import com.Acrobot.ChestShop.Listeners.AuthMeChestShopListener;
import com.Acrobot.ChestShop.Listeners.Block.BlockPlace;
import com.Acrobot.ChestShop.Listeners.Block.Break.ChestBreak;
import com.Acrobot.ChestShop.Listeners.Block.Break.SignBreak;
import com.Acrobot.ChestShop.Listeners.Block.SignCreate;
import com.Acrobot.ChestShop.Listeners.Economy.ServerAccountCorrector;
import com.Acrobot.ChestShop.Listeners.Economy.TaxModule;
import com.Acrobot.ChestShop.Listeners.GarbageTextListener;
import com.Acrobot.ChestShop.Listeners.Item.ItemMoveListener;
import com.Acrobot.ChestShop.Listeners.ItemInfoListener;
import com.Acrobot.ChestShop.Listeners.Modules.DiscountModule;
import com.Acrobot.ChestShop.Listeners.Modules.PriceRestrictionModule;
import com.Acrobot.ChestShop.Listeners.Player.PlayerConnect;
import com.Acrobot.ChestShop.Listeners.Player.PlayerInteract;
import com.Acrobot.ChestShop.Listeners.Player.PlayerInventory;
import com.Acrobot.ChestShop.Listeners.Player.PlayerLeave;
import com.Acrobot.ChestShop.Listeners.Player.PlayerTeleport;
import com.Acrobot.ChestShop.Listeners.PostShopCreation.CreationFeeGetter;
import com.Acrobot.ChestShop.Listeners.PostShopCreation.MessageSender;
import com.Acrobot.ChestShop.Listeners.PostShopCreation.ShopCreationLogger;
import com.Acrobot.ChestShop.Listeners.PostShopCreation.SignSticker;
import com.Acrobot.ChestShop.Listeners.PostTransaction.EconomicModule;
import com.Acrobot.ChestShop.Listeners.PostTransaction.EmptyShopDeleter;
import com.Acrobot.ChestShop.Listeners.PostTransaction.ItemManager;
import com.Acrobot.ChestShop.Listeners.PostTransaction.TransactionLogger;
import com.Acrobot.ChestShop.Listeners.PostTransaction.TransactionMessageSender;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.ChestChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.ErrorMessageSender;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.ItemChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.MoneyChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.NameChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.PriceChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.PriceRatioChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.QuantityChecker;
import com.Acrobot.ChestShop.Listeners.PreShopCreation.TerrainChecker;
import com.Acrobot.ChestShop.Listeners.PreTransaction.AmountAndPriceChecker;
import com.Acrobot.ChestShop.Listeners.PreTransaction.CreativeModeIgnorer;
import com.Acrobot.ChestShop.Listeners.PreTransaction.PartialTransactionModule;
import com.Acrobot.ChestShop.Listeners.PreTransaction.PermissionChecker;
import com.Acrobot.ChestShop.Listeners.PreTransaction.PriceValidator;
import com.Acrobot.ChestShop.Listeners.PreTransaction.ShopValidator;
import com.Acrobot.ChestShop.Listeners.PreTransaction.SpamClickProtector;
import com.Acrobot.ChestShop.Listeners.PreTransaction.StockFittingChecker;
import com.Acrobot.ChestShop.Listeners.ShopRemoval.ShopRefundListener;
import com.Acrobot.ChestShop.Listeners.ShopRemoval.ShopRemovalLogger;
import com.Acrobot.ChestShop.Logging.FileFormatter;
import com.Acrobot.ChestShop.Metadata.ItemDatabase;
import com.Acrobot.ChestShop.Signs.RestrictedSign;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestShop
extends JavaPlugin {
    private static ChestShop plugin;
    private static Server server;
    private static PluginDescriptionFile description;
    private static File dataFolder;
    private static ItemDatabase itemDatabase;
    private static Logger logger;
    private FileHandler handler;

    public ChestShop() {
        dataFolder = this.getDataFolder();
        logger = this.getLogger();
        description = this.getDescription();
        server = this.getServer();
        plugin = this;
    }

    public void onLoad() {
        Dependencies.initializePluginsOnLoad();
    }

    public void onEnable() {
        Configuration.pairFileAndClass(ChestShop.loadFile("config.yml"), Properties.class);
        Configuration.pairFileAndClass(ChestShop.loadFile("local.yml"), Messages.class);
        this.handleMigrations();
        itemDatabase = new ItemDatabase();
        NameManager.load();
        Dependencies.loadPlugins();
        this.registerEvents();
        if (Properties.LOG_TO_FILE) {
            File log = ChestShop.loadFile("ChestShop.log");
            FileHandler handler = ChestShop.loadHandler(log.getAbsolutePath());
            handler.setFormatter(new FileFormatter());
            this.handler = handler;
            logger.addHandler(handler);
        }
        if (!Properties.LOG_TO_CONSOLE) {
            logger.setUseParentHandlers(false);
        }
        this.getCommand("iteminfo").setExecutor((CommandExecutor)new ItemInfo());
        this.getCommand("csVersion").setExecutor((CommandExecutor)new Version());
        this.getCommand("csGive").setExecutor((CommandExecutor)new Give());
        this.getCommand("cstoggle").setExecutor((CommandExecutor)new Toggle());
    }

    private void handleMigrations() {
        int newVersion;
        int lastVersion;
        File versionFile = ChestShop.loadFile("version");
        YamlConfiguration previousVersion = YamlConfiguration.loadConfiguration((File)versionFile);
        if (previousVersion.get("version") == null) {
            previousVersion.set("version", (Object)2);
            try {
                previousVersion.save(versionFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((lastVersion = previousVersion.getInt("version")) != (newVersion = Migrations.migrate(lastVersion))) {
            previousVersion.set("version", (Object)newVersion);
            try {
                previousVersion.save(versionFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File loadFile(String string) {
        File file = new File(dataFolder, string);
        return ChestShop.loadFile(file);
    }

    private static File loadFile(File file) {
        if (!file.exists()) {
            try {
                if (file.getParent() != null) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private static FileHandler loadHandler(String path) {
        FileHandler handler = null;
        try {
            handler = new FileHandler(path, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return handler;
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        Toggle.clearToggledPlayers();
        if (this.handler != null) {
            this.handler.close();
            this.getLogger().removeHandler(this.handler);
        }
    }

    private void registerEvents() {
        this.registerEvent(new com.Acrobot.ChestShop.Plugins.ChestShop());
        this.registerPreShopCreationEvents();
        this.registerPreTransactionEvents();
        this.registerPostShopCreationEvents();
        this.registerPostTransactionEvents();
        this.registerShopRemovalEvents();
        this.registerModules();
        this.registerEvent(new SignBreak());
        this.registerEvent(new SignCreate());
        this.registerEvent(new ChestBreak());
        this.registerEvent(new BlockPlace());
        this.registerEvent(new PlayerConnect());
        this.registerEvent(new PlayerInteract());
        this.registerEvent(new PlayerInventory());
        this.registerEvent(new PlayerLeave());
        this.registerEvent(new PlayerTeleport());
        this.registerEvent(new ItemInfoListener());
        this.registerEvent(new GarbageTextListener());
        if (this.getServer().getPluginManager().getPlugin("AuthMe") != null && this.getServer().getPluginManager().getPlugin("ChestShop").isEnabled()) {
            this.registerEvent(new AuthMeChestShopListener());
        }
        this.registerEvent(new RestrictedSign());
        if (!Properties.TURN_OFF_HOPPER_PROTECTION) {
            this.registerEvent(new ItemMoveListener());
        }
    }

    private void registerShopRemovalEvents() {
        this.registerEvent(new ShopRefundListener());
        this.registerEvent(new ShopRemovalLogger());
    }

    private void registerPreShopCreationEvents() {
        if (Properties.BLOCK_SHOPS_WITH_SELL_PRICE_HIGHER_THAN_BUY_PRICE) {
            this.registerEvent(new PriceRatioChecker());
        }
        this.registerEvent(new ChestChecker());
        this.registerEvent(new ItemChecker());
        this.registerEvent(new MoneyChecker());
        this.registerEvent(new NameChecker());
        this.registerEvent(new com.Acrobot.ChestShop.Listeners.PreShopCreation.PermissionChecker());
        this.registerEvent(new ErrorMessageSender());
        this.registerEvent(new PriceChecker());
        this.registerEvent(new QuantityChecker());
        this.registerEvent(new TerrainChecker());
    }

    private void registerPostShopCreationEvents() {
        this.registerEvent(new CreationFeeGetter());
        this.registerEvent(new MessageSender());
        this.registerEvent(new SignSticker());
        this.registerEvent(new ShopCreationLogger());
    }

    private void registerPreTransactionEvents() {
        if (Properties.ALLOW_PARTIAL_TRANSACTIONS) {
            this.registerEvent(new PartialTransactionModule());
        } else {
            this.registerEvent(new AmountAndPriceChecker());
        }
        this.registerEvent(new CreativeModeIgnorer());
        this.registerEvent(new com.Acrobot.ChestShop.Listeners.PreTransaction.ErrorMessageSender());
        this.registerEvent(new PermissionChecker());
        this.registerEvent(new PriceValidator());
        this.registerEvent(new ShopValidator());
        this.registerEvent(new SpamClickProtector());
        this.registerEvent(new StockFittingChecker());
    }

    private void registerPostTransactionEvents() {
        this.registerEvent(new EconomicModule());
        this.registerEvent(new EmptyShopDeleter());
        this.registerEvent(new ItemManager());
        this.registerEvent(new TransactionLogger());
        this.registerEvent(new TransactionMessageSender());
    }

    private void registerModules() {
        this.registerEvent(new DiscountModule());
        this.registerEvent(new PriceRestrictionModule());
        this.registerEconomicalModules();
    }

    private void registerEconomicalModules() {
        this.registerEvent(new ServerAccountCorrector());
        this.registerEvent(new TaxModule());
    }

    public void registerEvent(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public static ItemDatabase getItemDatabase() {
        return itemDatabase;
    }

    public static File getFolder() {
        return dataFolder;
    }

    public static Logger getBukkitLogger() {
        return logger;
    }

    public static Server getBukkitServer() {
        return server;
    }

    public static String getVersion() {
        return description.getVersion();
    }

    public static String getPluginName() {
        return description.getName();
    }

    public static List<String> getDependencies() {
        return description.getSoftDepend();
    }

    public static ChestShop getPlugin() {
        return plugin;
    }

    public static void registerListener(Listener listener) {
        plugin.registerEvent(listener);
    }

    public static void callEvent(Event event) {
        Bukkit.getPluginManager().callEvent(event);
    }
}

