/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Events.Protection.BuildPermissionEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Security;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import org.bukkit.Location;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class TerrainChecker
implements Listener {
    @EventHandler
    public static void onPreShopCreation(PreShopCreationEvent event) {
        String nameLine = event.getSignLine((byte)0);
        if (ChestShopSign.isAdminShop(nameLine)) {
            return;
        }
        Player player = event.getPlayer();
        if (Permission.has((CommandSender)player, Permission.ADMIN)) {
            return;
        }
        if (!Security.canPlaceSign(player, event.getSign())) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_PERMISSION_FOR_TERRAIN);
            return;
        }
        Chest connectedChest = uBlock.findConnectedChest(event.getSign());
        Location chestLocation = connectedChest != null ? connectedChest.getLocation() : null;
        BuildPermissionEvent bEvent = new BuildPermissionEvent(player, chestLocation, event.getSign().getLocation());
        ChestShop.callEvent(bEvent);
        if (!bEvent.isAllowed()) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_PERMISSION_FOR_TERRAIN);
        }
    }
}

