/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.ORMlite.db;

import com.Acrobot.ChestShop.ORMlite.db.DatabaseType;
import com.Acrobot.ChestShop.ORMlite.field.BaseFieldConverter;
import com.Acrobot.ChestShop.ORMlite.field.DataPersister;
import com.Acrobot.ChestShop.ORMlite.field.FieldConverter;
import com.Acrobot.ChestShop.ORMlite.field.FieldType;
import com.Acrobot.ChestShop.ORMlite.field.SqlType;
import com.Acrobot.ChestShop.ORMlite.misc.SqlExceptionUtil;
import com.Acrobot.ChestShop.ORMlite.support.ConnectionSource;
import com.Acrobot.ChestShop.ORMlite.support.DatabaseResults;
import com.Acrobot.ChestShop.ORMlite.table.DatabaseTableConfig;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;

public abstract class BaseDatabaseType
implements DatabaseType {
    protected static String DEFAULT_SEQUENCE_SUFFIX = "_id_seq";
    protected Driver driver;

    protected abstract String getDriverClassName();

    @Override
    public void loadDriver() throws SQLException {
        String className = this.getDriverClassName();
        if (className != null) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw SqlExceptionUtil.create("Driver class was not found for " + this.getDatabaseName() + " database.  Missing jar with class " + className + ".", e);
            }
        }
    }

    @Override
    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    @Override
    public void appendColumnArg(String tableName, StringBuilder sb, FieldType fieldType, List<String> additionalArgs, List<String> statementsBefore, List<String> statementsAfter, List<String> queriesAfter) throws SQLException {
        this.appendEscapedEntityName(sb, fieldType.getColumnName());
        sb.append(' ');
        DataPersister dataPersister = fieldType.getDataPersister();
        int fieldWidth = fieldType.getWidth();
        if (fieldWidth == 0) {
            fieldWidth = dataPersister.getDefaultWidth();
        }
        switch (dataPersister.getSqlType()) {
            case STRING: {
                this.appendStringType(sb, fieldType, fieldWidth);
                break;
            }
            case LONG_STRING: {
                this.appendLongStringType(sb, fieldType, fieldWidth);
                break;
            }
            case BOOLEAN: {
                this.appendBooleanType(sb, fieldType, fieldWidth);
                break;
            }
            case DATE: {
                this.appendDateType(sb, fieldType, fieldWidth);
                break;
            }
            case CHAR: {
                this.appendCharType(sb, fieldType, fieldWidth);
                break;
            }
            case BYTE: {
                this.appendByteType(sb, fieldType, fieldWidth);
                break;
            }
            case BYTE_ARRAY: {
                this.appendByteArrayType(sb, fieldType, fieldWidth);
                break;
            }
            case SHORT: {
                this.appendShortType(sb, fieldType, fieldWidth);
                break;
            }
            case INTEGER: {
                this.appendIntegerType(sb, fieldType, fieldWidth);
                break;
            }
            case LONG: {
                this.appendLongType(sb, fieldType, fieldWidth);
                break;
            }
            case FLOAT: {
                this.appendFloatType(sb, fieldType, fieldWidth);
                break;
            }
            case DOUBLE: {
                this.appendDoubleType(sb, fieldType, fieldWidth);
                break;
            }
            case SERIALIZABLE: {
                this.appendSerializableType(sb, fieldType, fieldWidth);
                break;
            }
            case BIG_DECIMAL: {
                this.appendBigDecimalNumericType(sb, fieldType, fieldWidth);
                break;
            }
            case UUID: {
                this.appendUuidNativeType(sb, fieldType, fieldWidth);
                break;
            }
            case OTHER: {
                String sqlOtherType = dataPersister.getSqlOtherType();
                if (sqlOtherType == null) break;
                sb.append(sqlOtherType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SQL-type " + (Object)((Object)dataPersister.getSqlType()));
            }
        }
        sb.append(' ');
        if (fieldType.isGeneratedIdSequence() && !fieldType.isSelfGeneratedId()) {
            this.configureGeneratedIdSequence(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
        } else if (fieldType.isGeneratedId() && !fieldType.isSelfGeneratedId()) {
            this.configureGeneratedId(tableName, sb, fieldType, statementsBefore, statementsAfter, additionalArgs, queriesAfter);
        } else if (fieldType.isId()) {
            this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
        }
        if (!fieldType.isGeneratedId()) {
            Object defaultValue = fieldType.getDefaultValue();
            if (defaultValue != null) {
                sb.append("DEFAULT ");
                this.appendDefaultValue(sb, fieldType, defaultValue);
                sb.append(' ');
            }
            if (fieldType.isCanBeNull()) {
                this.appendCanBeNull(sb, fieldType);
            } else {
                sb.append("NOT NULL ");
            }
            if (fieldType.isUnique()) {
                this.addSingleUnique(sb, fieldType, additionalArgs, statementsAfter);
            }
        }
    }

    protected void appendStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        if (this.isVarcharFieldWidthSupported()) {
            sb.append("VARCHAR(").append(fieldWidth).append(')');
        } else {
            sb.append("VARCHAR");
        }
    }

    protected void appendUuidNativeType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        throw new UnsupportedOperationException("UUID is not supported by this database type");
    }

    protected void appendLongStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("TEXT");
    }

    protected void appendDateType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("TIMESTAMP");
    }

    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BOOLEAN");
    }

    protected void appendCharType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("CHAR");
    }

    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("TINYINT");
    }

    protected void appendShortType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    private void appendIntegerType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("INTEGER");
    }

    protected void appendLongType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BIGINT");
    }

    private void appendFloatType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("FLOAT");
    }

    private void appendDoubleType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("DOUBLE PRECISION");
    }

    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BLOB");
    }

    protected void appendSerializableType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BLOB");
    }

    protected void appendBigDecimalNumericType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("NUMERIC");
    }

    private void appendDefaultValue(StringBuilder sb, FieldType fieldType, Object defaultValue) {
        if (fieldType.isEscapedDefaultValue()) {
            this.appendEscapedWord(sb, defaultValue.toString());
        } else {
            sb.append(defaultValue);
        }
    }

    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) throws SQLException {
        throw new SQLException("GeneratedIdSequence is not supported by database " + this.getDatabaseName() + " for field " + fieldType);
    }

    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        throw new IllegalStateException("GeneratedId is not supported by database " + this.getDatabaseName() + " for field " + fieldType);
    }

    protected void configureId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
    }

    @Override
    public void addPrimaryKeySql(FieldType[] fieldTypes, List<String> additionalArgs, List<String> statementsBefore, List<String> statementsAfter, List<String> queriesAfter) {
        StringBuilder sb = null;
        for (FieldType fieldType : fieldTypes) {
            if (fieldType.isGeneratedId() && !this.generatedIdSqlAtEnd() && !fieldType.isSelfGeneratedId() || !fieldType.isId()) continue;
            if (sb == null) {
                sb = new StringBuilder(48);
                sb.append("PRIMARY KEY (");
            } else {
                sb.append(',');
            }
            this.appendEscapedEntityName(sb, fieldType.getColumnName());
        }
        if (sb != null) {
            sb.append(") ");
            additionalArgs.add(sb.toString());
        }
    }

    protected boolean generatedIdSqlAtEnd() {
        return true;
    }

    @Override
    public void addUniqueComboSql(FieldType[] fieldTypes, List<String> additionalArgs, List<String> statementsBefore, List<String> statementsAfter, List<String> queriesAfter) {
        StringBuilder sb = null;
        for (FieldType fieldType : fieldTypes) {
            if (!fieldType.isUniqueCombo()) continue;
            if (sb == null) {
                sb = new StringBuilder(48);
                sb.append("UNIQUE (");
            } else {
                sb.append(',');
            }
            this.appendEscapedEntityName(sb, fieldType.getColumnName());
        }
        if (sb != null) {
            sb.append(") ");
            additionalArgs.add(sb.toString());
        }
    }

    @Override
    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
    }

    @Override
    public void appendEscapedWord(StringBuilder sb, String word) {
        sb.append('\'').append(word).append('\'');
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('`');
        int dotPos = name.indexOf(46);
        if (dotPos > 0) {
            sb.append(name.substring(0, dotPos));
            sb.append("`.`");
            sb.append(name.substring(1 + dotPos));
        } else {
            sb.append(name);
        }
        sb.append('`');
    }

    @Override
    public String generateIdSequenceName(String tableName, FieldType idFieldType) {
        String name = tableName + DEFAULT_SEQUENCE_SUFFIX;
        if (this.isEntityNamesMustBeUpCase()) {
            return this.upCaseEntityName(name);
        }
        return name;
    }

    @Override
    public String getCommentLinePrefix() {
        return "-- ";
    }

    @Override
    public DataPersister getDataPersister(DataPersister defaultPersister, FieldType fieldType) {
        return defaultPersister;
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataPersister, FieldType fieldType) {
        return dataPersister;
    }

    @Override
    public boolean isIdSequenceNeeded() {
        return false;
    }

    @Override
    public boolean isVarcharFieldWidthSupported() {
        return true;
    }

    @Override
    public boolean isLimitSqlSupported() {
        return true;
    }

    @Override
    public boolean isOffsetSqlSupported() {
        return true;
    }

    @Override
    public boolean isOffsetLimitArgument() {
        return false;
    }

    @Override
    public boolean isLimitAfterSelect() {
        return false;
    }

    @Override
    public void appendLimitValue(StringBuilder sb, long limit, Long offset) {
        sb.append("LIMIT ").append(limit).append(' ');
    }

    @Override
    public void appendOffsetValue(StringBuilder sb, long offset) {
        sb.append("OFFSET ").append(offset).append(' ');
    }

    @Override
    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
    }

    @Override
    public void appendCreateTableSuffix(StringBuilder sb) {
    }

    @Override
    public boolean isCreateTableReturnsZero() {
        return true;
    }

    @Override
    public boolean isCreateTableReturnsNegative() {
        return false;
    }

    @Override
    public boolean isEntityNamesMustBeUpCase() {
        return false;
    }

    @Override
    public String upCaseEntityName(String entityName) {
        return this.upCaseString(entityName, true);
    }

    @Override
    public String upCaseString(String string, boolean forceEnglish) {
        if (forceEnglish) {
            return string.toUpperCase(Locale.ENGLISH);
        }
        return string.toUpperCase();
    }

    @Override
    public String downCaseString(String string, boolean forceEnglish) {
        if (forceEnglish) {
            return string.toLowerCase(Locale.ENGLISH);
        }
        return string.toLowerCase();
    }

    @Override
    public boolean isNestedSavePointsSupported() {
        return true;
    }

    @Override
    public String getPingStatement() {
        return "SELECT 1";
    }

    @Override
    public boolean isBatchUseTransaction() {
        return false;
    }

    @Override
    public boolean isTruncateSupported() {
        return false;
    }

    @Override
    public boolean isCreateIfNotExistsSupported() {
        return false;
    }

    @Override
    public boolean isCreateIndexIfNotExistsSupported() {
        return this.isCreateIfNotExistsSupported();
    }

    @Override
    public boolean isSelectSequenceBeforeInsert() {
        return false;
    }

    @Override
    public boolean isAllowGeneratedIdInsertSupported() {
        return true;
    }

    @Override
    public <T> DatabaseTableConfig<T> extractDatabaseTableConfig(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public void appendInsertNoColumns(StringBuilder sb) {
        sb.append("() VALUES ()");
    }

    private void appendCanBeNull(StringBuilder sb, FieldType fieldType) {
    }

    private void addSingleUnique(StringBuilder sb, FieldType fieldType, List<String> additionalArgs, List<String> statementsAfter) {
        StringBuilder alterSb = new StringBuilder();
        alterSb.append(" UNIQUE (");
        this.appendEscapedEntityName(alterSb, fieldType.getColumnName());
        alterSb.append(')');
        additionalArgs.add(alterSb.toString());
    }

    protected static class BooleanNumberFieldConverter
    extends BaseFieldConverter {
        protected BooleanNumberFieldConverter() {
        }

        @Override
        public SqlType getSqlType() {
            return SqlType.BOOLEAN;
        }

        @Override
        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            boolean bool = Boolean.parseBoolean(defaultStr);
            return bool ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }

        @Override
        public Object javaToSqlArg(FieldType fieldType, Object obj) {
            Boolean bool = (Boolean)obj;
            return bool != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }

        @Override
        public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getByte(columnPos);
        }

        @Override
        public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
            byte arg = (Byte)sqlArg;
            return arg == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }

        @Override
        public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) {
            return this.sqlArgToJava(fieldType, Byte.parseByte(stringValue), columnPos);
        }
    }
}

