/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class PriceChecker
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        String line = event.getSignLine((byte)2).toUpperCase();
        String[] part = (line = line.replaceAll("(\\.\\d*?[1-9])0+", "$1")).split(":");
        if (part.length > 1 && PriceChecker.isInvalid(part[0]) ^ PriceChecker.isInvalid(part[1])) {
            line = line.replace(':', ' ');
            part = new String[]{line};
        }
        if (part[0].split(" ").length > 2) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            return;
        }
        if (line.indexOf(66) != line.lastIndexOf(66) || line.indexOf(83) != line.lastIndexOf(83)) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            return;
        }
        if (PriceUtil.isPrice(part[0])) {
            line = "B " + line;
        }
        if (part.length > 1 && PriceUtil.isPrice(part[1])) {
            line = line + " S";
        }
        if (line.length() > 15) {
            line = line.replace(" ", "");
        }
        if (line.length() > 15) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            return;
        }
        event.setSignLine((byte)2, line);
        if (!PriceUtil.hasBuyPrice(line) && !PriceUtil.hasSellPrice(line)) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
        }
    }

    private static boolean isInvalid(String part) {
        char[] characters;
        for (char character : characters = new char[]{'B', 'S'}) {
            if (!part.contains(Character.toString(character))) continue;
            return !PriceUtil.hasPrice(part, character);
        }
        return false;
    }
}

