/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners;

import com.Acrobot.Breeze.Utils.EnchantmentNames;
import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.Breeze.Utils.PotionNames;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.Events.ItemInfoEvent;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;

public class ItemInfoListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public static void addDamage(ItemInfoEvent event) {
        Repairable repairable;
        ItemStack item = event.getItem();
        CommandSender sender = event.getSender();
        ItemMeta meta = item.getItemMeta();
        short maxdurability = item.getType().getMaxDurability();
        if (maxdurability > 0 && meta instanceof Damageable) {
            int remainingDurability = maxdurability - ((Damageable)meta).getDamage();
            sender.sendMessage("    " + ChatColor.RED + "Durability: " + remainingDurability + "/" + maxdurability);
        }
        if (meta instanceof Repairable && (repairable = (Repairable)meta).hasRepairCost()) {
            sender.sendMessage("    " + ChatColor.RED + "Additional Repair Cost: " + repairable.getRepairCost());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public static void addName(ItemInfoEvent event) {
        ItemStack item = event.getItem();
        CommandSender sender = event.getSender();
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            sender.sendMessage("    " + ChatColor.GRAY + "Name: " + meta.getDisplayName());
        }
    }

    @EventHandler
    public static void addEnchantment(ItemInfoEvent event) {
        EnchantmentStorageMeta ench;
        ItemStack item = event.getItem();
        CommandSender sender = event.getSender();
        ItemMeta meta = item.getItemMeta();
        Map enchantments = item.getEnchantments();
        for (Map.Entry enchantment : enchantments.entrySet()) {
            sender.sendMessage("    " + ChatColor.GRAY + EnchantmentNames.getName((Enchantment)enchantment.getKey()) + ' ' + NumberUtil.toRoman((Integer)enchantment.getValue()));
        }
        if (meta instanceof EnchantmentStorageMeta && (ench = (EnchantmentStorageMeta)meta).hasStoredEnchants()) {
            for (Map.Entry enchantment : ench.getStoredEnchants().entrySet()) {
                sender.sendMessage("    " + ChatColor.GRAY + EnchantmentNames.getName((Enchantment)enchantment.getKey()) + ' ' + NumberUtil.toRoman((Integer)enchantment.getValue()));
            }
        }
    }

    @EventHandler
    public static void addPotionInfo(ItemInfoEvent event) {
        ItemStack item = event.getItem();
        Material t = item.getType();
        if (t != Material.POTION && t != Material.SPLASH_POTION && t != Material.LINGERING_POTION && t != Material.TIPPED_ARROW) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof PotionMeta)) {
            return;
        }
        PotionMeta potion = (PotionMeta)meta;
        StringBuilder message = new StringBuilder(50);
        message.append(ChatColor.GRAY);
        PotionData base = potion.getBasePotionData();
        if (base == null) {
            return;
        }
        if (base.isExtended()) {
            message.append("Extended ");
        }
        if (t == Material.SPLASH_POTION) {
            message.append("Splash ");
        }
        if (t == Material.LINGERING_POTION) {
            message.append("Lingering ");
        }
        message.append(PotionNames.getName(base.getType())).append(' ');
        if (base.isUpgraded()) {
            message.append("II ");
        }
        CommandSender sender = event.getSender();
        sender.sendMessage("    " + message.toString());
        if (potion.hasCustomEffects()) {
            for (PotionEffect effect : potion.getCustomEffects()) {
                sender.sendMessage("    " + ChatColor.GRAY + StringUtil.capitalizeFirstLetter(effect.getType().getName(), '_') + ' ' + NumberUtil.toTime(effect.getDuration() / 20));
            }
        }
    }
}

