/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils.MojangAPI;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;

public class UUIDFetcher
implements Callable<Map<String, UUID>> {
    private static final int MAX_SEARCH = 100;
    private static final String PROFILE_URL = "https://api.mojang.com/profiles/page/";
    private static final String AGENT = "minecraft";
    private final JSONParser jsonParser = new JSONParser();
    private final List<String> names;

    public UUIDFetcher(String ... names) {
        this.names = ImmutableList.copyOf((Object[])names);
    }

    public UUIDFetcher(String name) {
        this.names = ImmutableList.of((Object)name);
    }

    @Override
    public Map<String, UUID> call() throws Exception {
        HashMap<String, UUID> uuidMap = new HashMap<String, UUID>();
        String body = UUIDFetcher.buildBody(this.names);
        for (int i = 1; i < 100; ++i) {
            HttpURLConnection connection = UUIDFetcher.createConnection(i);
            UUIDFetcher.writeBody(connection, body);
            JSONObject jsonObject = (JSONObject)this.jsonParser.parse((Reader)new InputStreamReader(connection.getInputStream()));
            JSONArray array = (JSONArray)jsonObject.get((Object)"profiles");
            Number count = (Number)jsonObject.get((Object)"size");
            if (count.intValue() == 0) break;
            for (Object profile : array) {
                JSONObject jsonProfile = (JSONObject)profile;
                String id = (String)jsonProfile.get((Object)"id");
                String name = (String)jsonProfile.get((Object)"name");
                UUID uuid = UUID.fromString(id.substring(0, 8) + "-" + id.substring(8, 12) + "-" + id.substring(12, 16) + "-" + id.substring(16, 20) + "-" + id.substring(20, 32));
                uuidMap.put(name, uuid);
            }
        }
        return uuidMap;
    }

    private static void writeBody(HttpURLConnection connection, String body) throws Exception {
        DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
        writer.write(body.getBytes());
        writer.flush();
        writer.close();
    }

    private static HttpURLConnection createConnection(int page) throws Exception {
        URL url = new URL(PROFILE_URL + page);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        return connection;
    }

    private static String buildBody(List<String> names) {
        ArrayList<JSONObject> lookups = new ArrayList<JSONObject>();
        for (String name : names) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"name", (Object)name);
            jsonObject.put((Object)"agent", (Object)AGENT);
            lookups.add(jsonObject);
        }
        return JSONValue.toJSONString(lookups);
    }
}

