/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.ORMlite.jdbc;

import com.Acrobot.ChestShop.ORMlite.db.DatabaseType;
import com.Acrobot.ChestShop.ORMlite.db.DatabaseTypeUtils;
import com.Acrobot.ChestShop.ORMlite.jdbc.JdbcDatabaseConnection;
import com.Acrobot.ChestShop.ORMlite.logger.Logger;
import com.Acrobot.ChestShop.ORMlite.logger.LoggerFactory;
import com.Acrobot.ChestShop.ORMlite.misc.IOUtils;
import com.Acrobot.ChestShop.ORMlite.support.BaseConnectionSource;
import com.Acrobot.ChestShop.ORMlite.support.ConnectionSource;
import com.Acrobot.ChestShop.ORMlite.support.DatabaseConnection;
import com.Acrobot.ChestShop.ORMlite.support.DatabaseConnectionProxyFactory;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class JdbcConnectionSource
extends BaseConnectionSource
implements ConnectionSource {
    private static Logger logger = LoggerFactory.getLogger(JdbcConnectionSource.class);
    private String url;
    private String username;
    private String password;
    protected DatabaseConnection connection;
    protected DatabaseType databaseType;
    protected boolean initialized = false;
    private static DatabaseConnectionProxyFactory connectionProxyFactory;

    public JdbcConnectionSource() {
    }

    public JdbcConnectionSource(String url) throws SQLException {
        this(url, null, null, null);
    }

    public JdbcConnectionSource(String url, DatabaseType databaseType) throws SQLException {
        this(url, null, null, databaseType);
    }

    public JdbcConnectionSource(String url, String username, String password) throws SQLException {
        this(url, username, password, null);
    }

    public JdbcConnectionSource(String url, String username, String password, DatabaseType databaseType) throws SQLException {
        this.url = url;
        this.username = username;
        this.password = password;
        this.databaseType = databaseType;
        this.initialize();
    }

    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        if (this.url == null) {
            throw new SQLException("url was never set on " + this.getClass().getSimpleName());
        }
        if (this.databaseType == null) {
            this.databaseType = DatabaseTypeUtils.createDatabaseType(this.url);
        }
        this.databaseType.loadDriver();
        this.databaseType.setDriver(DriverManager.getDriver(this.url));
        this.initialized = true;
    }

    @Override
    public void close() throws IOException {
        if (!this.initialized) {
            throw new IOException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        if (this.connection != null) {
            this.connection.close();
            logger.debug("closed connection #{}", this.connection.hashCode());
            this.connection = null;
        }
    }

    @Override
    public void closeQuietly() {
        IOUtils.closeQuietly(this);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public DatabaseConnection getReadOnlyConnection(String tableName) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        return this.getReadWriteConnection(tableName);
    }

    @Override
    public DatabaseConnection getReadWriteConnection(String tableName) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                throw new SQLException("Connection has already been closed");
            }
            return this.connection;
        }
        this.connection = this.makeConnection(logger);
        return this.connection;
    }

    @Override
    public void releaseConnection(DatabaseConnection connection) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
    }

    @Override
    public boolean saveSpecialConnection(DatabaseConnection connection) throws SQLException {
        return true;
    }

    @Override
    public void clearSpecialConnection(DatabaseConnection connection) {
    }

    @Override
    public DatabaseType getDatabaseType() {
        if (!this.initialized) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        return this.databaseType;
    }

    @Override
    public boolean isOpen(String tableName) {
        return this.connection != null;
    }

    @Override
    public boolean isSingleConnection(String tableName) {
        return true;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public static void setDatabaseConnectionProxyFactory(DatabaseConnectionProxyFactory connectionProxyFactory) {
        JdbcConnectionSource.connectionProxyFactory = connectionProxyFactory;
    }

    protected DatabaseConnection makeConnection(Logger logger) throws SQLException {
        Properties properties = new Properties();
        if (this.username != null) {
            properties.setProperty("user", this.username);
        }
        if (this.password != null) {
            properties.setProperty("password", this.password);
        }
        DatabaseConnection connection = new JdbcDatabaseConnection(DriverManager.getConnection(this.url, properties));
        connection.setAutoCommit(true);
        if (connectionProxyFactory != null) {
            connection = connectionProxyFactory.createProxy(connection);
        }
        logger.debug("opened connection to {} got #{}", (Object)this.url, (Object)connection.hashCode());
        return connection;
    }
}

