/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.Acrobot.Breeze.Utils.AlternativeItemNames;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MaterialUtil {
    private static final Map<String, Material> MATERIAL_CACHE = new HashMap<String, Material>();

    public static boolean isEmpty(ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }

    private static Material getMaterial(String name) {
        String formatted = name.replaceAll(" |_", "").toUpperCase();
        if (MATERIAL_CACHE.containsKey(formatted)) {
            return MATERIAL_CACHE.get(formatted);
        }
        Material material = AlternativeItemNames.getItem(formatted);
        if (material == null) {
            material = Material.matchMaterial((String)name);
        }
        if (material != null) {
            MATERIAL_CACHE.put(formatted, material);
            return material;
        }
        int length = Short.MAX_VALUE;
        for (Map.Entry<String, Material> e : AlternativeItemNames.NAME_TO_ITEM.entrySet()) {
            String matName = e.getKey();
            if (matName.length() >= length || !matName.replace("_", "").startsWith(formatted)) continue;
            length = (short)matName.length();
            material = e.getValue();
        }
        for (Material currentMaterial : Material.values()) {
            String matName = currentMaterial.name();
            if (matName.length() >= length || !matName.replace("_", "").startsWith(formatted)) continue;
            length = (short)matName.length();
            material = currentMaterial;
        }
        MATERIAL_CACHE.put(formatted, material);
        return material;
    }

    public static String getName(Material material) {
        String name = AlternativeItemNames.getName(material);
        if (name == null) {
            name = material.name();
        }
        return StringUtil.capitalizeFirstLetter(name, '_');
    }

    public static String getSignName(ItemStack itemStack) {
        StringBuilder name = new StringBuilder(15);
        name.append(MaterialUtil.getName(itemStack.getType()));
        if (itemStack.hasItemMeta()) {
            name.append('#').append(Metadata.getItemCode(itemStack));
        }
        return name.toString();
    }

    public static ItemStack getItem(String itemName) {
        ItemMeta meta;
        Material material;
        String materialString = itemName;
        String metaString = null;
        int metaStart = itemName.indexOf(35);
        if (metaStart >= 0) {
            materialString = itemName.substring(0, metaStart);
            metaString = itemName.substring(metaStart + 1);
        }
        if ((material = MaterialUtil.getMaterial(materialString)) == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(material);
        if (metaString != null && (meta = Metadata.getFromCode(metaString)) != null) {
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    public static class Metadata {
        public static String getMetaCodeFromItemCode(String itemName) {
            int metaStart = itemName.indexOf(35);
            if (metaStart >= 0) {
                return itemName.substring(metaStart + 1);
            }
            return null;
        }

        public static ItemMeta getFromCode(String code) {
            ItemStack item = ChestShop.getItemDatabase().getFromCode(code);
            if (item == null) {
                return null;
            }
            return item.getItemMeta();
        }

        public static String getItemCode(ItemStack item) {
            return ChestShop.getItemDatabase().getItemCode(item);
        }
    }
}

