/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.UUIDs;

import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class NameManager {
    private static final UUID adminShopUUID = UUID.nameUUIDFromBytes("ChestShop-Adminshop".getBytes());
    private static final UUID serverAccountUUID = UUID.nameUUIDFromBytes("ChestShop-ServerAccount".getBytes());

    public static String getNameFor(Player player) {
        return player.getName();
    }

    public static UUID getUUIDForFullName(String name) {
        if (ChestShopSign.isAdminshopLine(name)) {
            return adminShopUUID;
        }
        if (Properties.SERVER_ECONOMY_ACCOUNT != null && Properties.SERVER_ECONOMY_ACCOUNT.length() > 0 && Properties.SERVER_ECONOMY_ACCOUNT.equals(name)) {
            return serverAccountUUID;
        }
        OfflinePlayer offlinePlayer = Bukkit.getServer().getOfflinePlayerIfCached(name);
        if (offlinePlayer != null) {
            return offlinePlayer.getUniqueId();
        }
        return null;
    }

    public static String getFullNameFor(UUID playerId) {
        if (NameManager.isAdminShop(playerId)) {
            return Properties.ADMIN_SHOP_NAME;
        }
        if (NameManager.isServerAccount(playerId)) {
            return Properties.SERVER_ECONOMY_ACCOUNT;
        }
        OfflinePlayer offlinePlayer = Bukkit.getServer().getOfflinePlayer(playerId);
        return offlinePlayer.getName() != null ? offlinePlayer.getName() : playerId.toString();
    }

    public static boolean isAdminShop(UUID uuid) {
        return adminShopUUID.equals(uuid);
    }

    public static UUID getAdminShopUUID() {
        return adminShopUUID;
    }

    public static boolean isServerAccount(UUID uuid) {
        return serverAccountUUID.equals(uuid);
    }

    public static UUID getServerAccountUUID() {
        return serverAccountUUID;
    }
}

