/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Block;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Events.ShopCreatedEvent;
import com.Acrobot.ChestShop.ItemNaming.ItemNamingUtils;
import com.Acrobot.ChestShop.Signs.ChestShopMetaData;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SignCreate
implements Listener {
    public static final String AUTOFILL_CODE = "?";
    public static final String AUTOFILL_SHULKER_CONTENT_CODE = "??";

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public static void onSignChange(SignChangeEvent event) {
        Block signBlock = event.getBlock();
        boolean wasChestShop = ChestShopSign.isChestShop(signBlock);
        if (event.getSide() == Side.BACK) {
            if (wasChestShop) {
                event.setCancelled(true);
            }
            return;
        }
        List line = event.lines();
        if (!BlockUtil.isSign(signBlock)) {
            if (wasChestShop) {
                ChestShopSign.removeChestShopMetaData(signBlock, true);
            }
            return;
        }
        if (!ChestShopSign.isValidPreparedSign(line)) {
            if (wasChestShop) {
                ChestShopSign.removeChestShopMetaData(signBlock, true);
            }
            return;
        }
        ItemStack itemStack = SignCreate.getItemStack(event.line(3), (Sign)event.getBlock().getState());
        if (itemStack == null || itemStack.isEmpty()) {
            if (wasChestShop) {
                ChestShopSign.removeChestShopMetaData(signBlock, true);
            }
            return;
        }
        itemStack.setAmount(1);
        Sign sign = (Sign)signBlock.getState();
        ChestShopMetaData oldData = wasChestShop ? ChestShopSign.getChestShopMetaData(sign) : null;
        LegacyComponentSerializer serializer = LegacyComponentSerializer.legacyAmpersand();
        String[] serializedLines = new String[line.size()];
        for (int i = 0; i < line.size(); ++i) {
            serializedLines[i] = (String)serializer.serializeOr((Component)line.get(i), (Object)"");
        }
        PreShopCreationEvent preEvent = new PreShopCreationEvent(event.getPlayer(), (Sign)signBlock.getState(), serializedLines, itemStack);
        if (oldData != null) {
            preEvent.setAmount(oldData.getQuantity());
            preEvent.setEnforceAmount(oldData.isEnforceQuantity());
            preEvent.setNoAutofill(oldData.isNoAutofill());
        }
        ChestShop.callEvent(preEvent);
        if (preEvent.isCancelled()) {
            if (wasChestShop) {
                ChestShopSign.removeChestShopMetaData(signBlock, true);
            }
            return;
        }
        SignSide side = sign.getSide(event.getSide());
        for (byte i = 0; i < line.size(); i = (byte)(i + 1)) {
            event.line((int)i, serializer.deserializeOrNull((Object)preEvent.getSignLine(i)));
            side.line((int)i, serializer.deserializeOrNull((Object)preEvent.getSignLine(i)));
        }
        ChestShopMetaData chestShopMetaData = SignCreate.createShopMetaData(event.getPlayer(), preEvent.getShopOwnerId(), event.lines(), itemStack, preEvent.getAmount(), preEvent.isEnforceAmount(), preEvent.isNoAutofill());
        ShopCreatedEvent postEvent = new ShopCreatedEvent(preEvent.getPlayer(), preEvent.getSign(), uBlock.findConnectedChest(preEvent.getSign()), preEvent.getSignLines(), chestShopMetaData);
        ChestShop.callEvent(postEvent);
        SignSide signSide = sign.getSide(Side.BACK);
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            signSide.line(i, (Component)Component.empty());
        }
        ChestShopSign.saveChestShopMetaData(sign, chestShopMetaData, true);
    }

    public static ChestShopMetaData createShopMetaData(Player creator, UUID shopOwnerId, List<Component> signLines, ItemStack itemStack, int quantity, boolean enforceQuantity, boolean noAutofill) {
        String priceLine = PlainTextComponentSerializer.plainText().serialize(signLines.get(2));
        double sellPrice = PriceUtil.getSellPrice(priceLine);
        double buyPrice = PriceUtil.getBuyPrice(priceLine);
        return new ChestShopMetaData(shopOwnerId, quantity, enforceQuantity, sellPrice, buyPrice, itemStack, noAutofill);
    }

    private static ItemStack getItemStack(Component lineComponent, Sign sign) {
        ItemStack itemStack;
        String oldItemDisplayName;
        ChestShopMetaData chestShopMetaData;
        String linePlain = PlainTextComponentSerializer.plainText().serialize(lineComponent);
        if (ChestShopSign.isChestShop(sign) && (chestShopMetaData = ChestShopSign.getChestShopMetaData(sign)) != null && (oldItemDisplayName = ChatColor.stripColor((String)ItemNamingUtils.getSignItemName(itemStack = chestShopMetaData.getItemStack()))).equals(linePlain)) {
            return itemStack;
        }
        ItemStack item = null;
        if (Properties.ALLOW_AUTO_ITEM_FILL && (linePlain.equals(AUTOFILL_CODE) || linePlain.equals(AUTOFILL_SHULKER_CONTENT_CODE))) {
            item = SignCreate.autoFillItemStack(sign, linePlain);
        } else {
            Material material = ItemNamingUtils.getItemFromSignName(linePlain);
            if (material != null) {
                item = new ItemStack(material);
            }
        }
        return item;
    }

    private static ItemStack autoFillItemStack(Sign sign, String itemLine) {
        Container connectedChest = uBlock.findConnectedChest(sign, true);
        if (connectedChest != null) {
            return itemLine.equals(AUTOFILL_SHULKER_CONTENT_CODE) ? SignCreate.autoFillItemStackFromShulker(connectedChest) : SignCreate.autoFillItemStackFromChest(connectedChest);
        }
        return null;
    }

    private static ItemStack autoFillItemStackFromChest(Container connectedChest) {
        for (ItemStack stack : connectedChest.getInventory().getContents()) {
            if (MaterialUtil.isEmpty(stack)) continue;
            stack = stack.clone();
            stack.setAmount(1);
            return stack;
        }
        return null;
    }

    private static ItemStack autoFillItemStackFromShulker(Container connectedChest) {
        for (ItemStack stack : connectedChest.getInventory().getContents()) {
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta meta;
            if (MaterialUtil.isEmpty(stack) || !BlockUtil.isShulkerBox(stack.getType()) || !((meta = stack.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            for (ItemStack shulkerContent : shulkerBox.getSnapshotInventory().getStorageContents()) {
                if (MaterialUtil.isEmpty(shulkerContent)) continue;
                shulkerContent = shulkerContent.clone();
                shulkerContent.setAmount(1);
                return shulkerContent;
            }
        }
        return null;
    }
}

