/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Block.Break;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.ShopDestroyedEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopMetaData;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Container;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;

public class SignBreak
implements Listener {
    private final BlockFace[] SIGN_CONNECTION_FACES = new BlockFace[]{BlockFace.SOUTH, BlockFace.NORTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP};
    private final HashMap<Location, UUID> signBreakers = new HashMap();

    public SignBreak() {
        ChestShop.getPlugin().getServer().getScheduler().runTaskTimer((Plugin)ChestShop.getPlugin(), this::cleanup, 20L, 20L);
    }

    public void cleanup() {
        if (!this.signBreakers.isEmpty()) {
            this.signBreakers.clear();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onSign(BlockPhysicsEvent event) {
        Block block = event.getBlock();
        if (!BlockUtil.isSign(block)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        Block attachedBlock = BlockUtil.getAttachedBlock(sign);
        if (attachedBlock.getType() == Material.AIR && ChestShopSign.isChestShop(sign)) {
            UUID breaker = this.signBreakers.remove(block.getLocation());
            if (breaker == null) {
                return;
            }
            Player player = Bukkit.getPlayer((UUID)breaker);
            if (player == null) {
                return;
            }
            this.sendShopDestroyedEvent(sign, player);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSignBreak(BlockBreakEvent event) {
        if (!this.canBlockBeBroken(event.getBlock(), event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBrokenSign(BlockBreakEvent event) {
        if (ChestShopSign.isChestShop(event.getBlock())) {
            this.sendShopDestroyedEvent((Sign)event.getBlock().getState(), event.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (this.canBlockBeBroken(block, null)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            if (this.canBlockBeBroken(block, null)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onExplosion(EntityExplodeEvent event) {
        if (event.blockList() == null || !Properties.USE_BUILT_IN_PROTECTION) {
            return;
        }
        for (Block block : event.blockList()) {
            if (this.canBlockBeBroken(block, null)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onIgnite(BlockBurnEvent event) {
        if (!this.canBlockBeBroken(event.getBlock(), null)) {
            event.setCancelled(true);
        }
    }

    public boolean canBlockBeBroken(Block block, Player breaker) {
        List<Sign> attachedSigns = this.getAttachedSigns(block);
        LinkedList<Sign> brokenBlocks = new LinkedList<Sign>();
        boolean canBeBroken = true;
        for (Sign sign : attachedSigns) {
            if (!canBeBroken || !ChestShopSign.isChestShop(sign)) continue;
            if (Properties.TURN_OFF_SIGN_PROTECTION || this.canDestroyShop(breaker, sign)) {
                brokenBlocks.add(sign);
                continue;
            }
            canBeBroken = false;
        }
        if (!canBeBroken) {
            return false;
        }
        for (Sign sign : brokenBlocks) {
            this.signBreakers.put(sign.getLocation(), breaker.getUniqueId());
        }
        return true;
    }

    private boolean canDestroyShop(Player player, Sign sign) {
        return player != null && (this.hasShopBreakingPermission(player) || ChestShopSign.isOwner((OfflinePlayer)player, sign));
    }

    private boolean hasShopBreakingPermission(Player player) {
        return Permission.has((CommandSender)player, Permission.ADMIN) || Permission.has((CommandSender)player, Permission.MOD);
    }

    private void sendShopDestroyedEvent(Sign sign, Player player) {
        Container connectedChest = null;
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        if (!chestShopMetaData.isAdminshop()) {
            connectedChest = uBlock.findConnectedChest(sign);
        }
        ShopDestroyedEvent event = new ShopDestroyedEvent(player, sign, connectedChest, chestShopMetaData);
        ChestShop.callEvent(event);
    }

    private List<Sign> getAttachedSigns(Block block) {
        if (block == null) {
            return Lists.newArrayList();
        }
        if (BlockUtil.isSign(block)) {
            return Collections.singletonList((Sign)block.getState());
        }
        LinkedList<Sign> attachedSigns = new LinkedList<Sign>();
        for (BlockFace face : this.SIGN_CONNECTION_FACES) {
            Sign sign;
            Block relative = block.getRelative(face);
            if (!BlockUtil.isSign(relative) || !BlockUtil.getAttachedBlock(sign = (Sign)relative.getState()).equals((Object)block)) continue;
            attachedSigns.add(sign);
        }
        return attachedSigns;
    }
}

