/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.Acrobot.Breeze.Utils.NumberUtil;
import java.util.regex.Pattern;

public class PriceUtil {
    public static final double NO_PRICE = -1.0;
    public static final double FREE = 0.0;
    public static final String FREE_TEXT = "free";
    public static final char BUY_INDICATOR = 'b';
    public static final char SELL_INDICATOR = 's';
    public static final Pattern VALID_PRICE_PATTERN = Pattern.compile("^[0-9]*(\\.[0-9]*)?$");

    public static double get(String text, char indicator) {
        String[] split = text.replace(" ", "").toLowerCase().split(":");
        String character = String.valueOf(indicator).toLowerCase();
        for (String part : split) {
            if (!part.startsWith(character) && !part.endsWith(character)) continue;
            if ((part = part.replace(character, "")).equals(FREE_TEXT)) {
                return 0.0;
            }
            if (!NumberUtil.isDouble(part)) continue;
            double price = Double.valueOf(part);
            if (!Double.isFinite(price) || price <= 0.0) {
                return -1.0;
            }
            return price;
        }
        return -1.0;
    }

    public static double getBuyPrice(String text) {
        return PriceUtil.get(text, 'b');
    }

    public static double getSellPrice(String text) {
        return PriceUtil.get(text, 's');
    }

    public static boolean hasBuyPrice(String text) {
        return PriceUtil.hasPrice(text, 'b');
    }

    public static boolean hasSellPrice(String text) {
        return PriceUtil.hasPrice(text, 's');
    }

    public static boolean hasPrice(String text, char indicator) {
        return PriceUtil.get(text, indicator) != -1.0;
    }

    public static boolean isPrice(String text) {
        if ((text = text.trim()).equalsIgnoreCase(FREE_TEXT)) {
            return true;
        }
        if (!VALID_PRICE_PATTERN.matcher(text).matches()) {
            return false;
        }
        try {
            double value = Double.parseDouble(text);
            if (!Double.isFinite(value) || value < 0.0) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

