/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.ItemNaming;

import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ItemNaming.ItemDisplayNameShortener;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class PriorityItemDisplayNameShortener
implements ItemDisplayNameShortener {
    private final Map<Integer, StringShortenerPairHolder> pairHolderMap = new TreeMap<Integer, StringShortenerPairHolder>();

    public void addMapping(Integer priority, String from, String to) {
        StringShortenerPairHolder pairHolder;
        if (!this.pairHolderMap.containsKey(priority)) {
            pairHolder = new StringShortenerPairHolder();
            this.pairHolderMap.put(priority, pairHolder);
        } else {
            pairHolder = this.pairHolderMap.get(priority);
        }
        pairHolder.addShortenerPair(from, to);
    }

    @Override
    public String shorten(String string, int length) {
        if (string.length() <= length) {
            return string;
        }
        String result = string;
        String strippedResult = StringUtil.stripWhitespaces(result);
        if (strippedResult.length() <= length) {
            return strippedResult;
        }
        for (Map.Entry<Integer, StringShortenerPairHolder> integerStringShortenerPairHolderEntry : this.pairHolderMap.entrySet()) {
            StringShortenerPairHolder value = integerStringShortenerPairHolderEntry.getValue();
            result = value.apply(result).strip();
            if (result.length() <= length) {
                return result;
            }
            strippedResult = StringUtil.stripWhitespaces(result);
            if (strippedResult.length() > length) continue;
            return strippedResult;
        }
        return result;
    }

    private static class StringShortenerPairHolder {
        private final Set<StringShortenerPair> shortenerPairs = new TreeSet<StringShortenerPair>(StringShortenerPair::compareTo);

        public void addShortenerPair(String from, String to) {
            this.shortenerPairs.add(new StringShortenerPair(from, to));
        }

        public String apply(String string) {
            String result = string;
            for (StringShortenerPair pair : this.shortenerPairs) {
                result = pair.apply(result);
            }
            return result;
        }
    }

    private record StringShortenerPair(String from, String to) implements Comparable<StringShortenerPair>
    {
        public String apply(String string) {
            return string.replaceAll("(?<=( |^))" + Pattern.quote(this.from) + "(?=( |$))", this.to);
        }

        @Override
        public int compareTo(StringShortenerPair o) {
            if (this.equals(o)) {
                return 0;
            }
            if (o.to.contains(this.from)) {
                return -1;
            }
            return 1;
        }
    }
}

