/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners;

import com.Acrobot.Breeze.Utils.EnchantmentNames;
import com.Acrobot.Breeze.Utils.FireworkEffectTypeNames;
import com.Acrobot.Breeze.Utils.NumberUtil;
import com.Acrobot.Breeze.Utils.PotionNames;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.Events.ItemInfoEvent;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Beehive;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.DecoratedPot;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MusicInstrumentMeta;
import org.bukkit.inventory.meta.OminousBottleMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.potion.PotionEffect;

public class ItemInfoListener
implements Listener {
    /*
     * WARNING - void declaration
     */
    @EventHandler
    public static void addInfo(ItemInfoEvent event) {
        List lore;
        CrossbowMeta crossbowMeta;
        ArmorMeta armorMeta;
        LeatherArmorMeta leatherArmorMeta;
        Color color;
        AxolotlBucketMeta axolotlBucketMeta;
        TropicalFishBucketMeta tropicalFishBucketMeta;
        BlockState blockState;
        BlockStateMeta blockStateMeta;
        String string;
        SkullMeta skull;
        FireworkEffectMeta fireworkEffect;
        EnchantmentStorageMeta ench;
        Repairable repairable;
        short maxdurability;
        CommandSender sender = event.getSender();
        ItemStack item = event.getItem();
        Material type = item.getType();
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName() && !(meta instanceof BookMeta)) {
            sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Name: " + meta.getDisplayName());
        }
        if ((maxdurability = type.getMaxDurability()) > 0 && meta instanceof Damageable) {
            int remainingDurability = maxdurability - ((Damageable)meta).getDamage();
            sender.sendMessage("    " + String.valueOf(ChatColor.RED) + "Durability: " + remainingDurability + "/" + maxdurability);
        }
        if (meta instanceof Repairable && (repairable = (Repairable)meta).hasRepairCost()) {
            sender.sendMessage("    " + String.valueOf(ChatColor.RED) + "Additional Repair Cost: " + repairable.getRepairCost());
        }
        if (meta instanceof BookMeta) {
            BookMeta book = (BookMeta)meta;
            if (meta.hasDisplayName()) {
                sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Title: " + meta.getDisplayName());
            } else if (book.hasTitle()) {
                sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Title: " + book.getTitle());
            }
            if (book.hasAuthor()) {
                sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Author: " + book.getAuthor());
            }
            if (book.hasGeneration() && book.getGeneration() != BookMeta.Generation.ORIGINAL) {
                sender.sendMessage("    " + String.valueOf(ChatColor.RED) + StringUtil.capitalizeFirstLetter(book.getGeneration().name(), '_'));
            }
        }
        Map enchantments = item.getEnchantments();
        for (Map.Entry entry : enchantments.entrySet()) {
            sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + EnchantmentNames.getName((Enchantment)entry.getKey()) + (String)(((Enchantment)entry.getKey()).getMaxLevel() > 1 || (Integer)entry.getValue() != 1 ? " " + NumberUtil.toRoman((Integer)entry.getValue()) : ""));
        }
        if (meta instanceof EnchantmentStorageMeta && (ench = (EnchantmentStorageMeta)meta).hasStoredEnchants()) {
            for (Map.Entry entry : ench.getStoredEnchants().entrySet()) {
                sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + EnchantmentNames.getName((Enchantment)entry.getKey()) + (String)(((Enchantment)entry.getKey()).getMaxLevel() > 1 || (Integer)entry.getValue() != 1 ? " " + NumberUtil.toRoman((Integer)entry.getValue()) : ""));
            }
        }
        if (meta instanceof FireworkMeta) {
            FireworkMeta firework = (FireworkMeta)meta;
            sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Flight Duration: " + (firework.getPower() == 0 ? 1 : firework.getPower()));
            for (FireworkEffect fireworkEffect2 : firework.getEffects()) {
                ItemInfoListener.sendFireworkEffect(sender, fireworkEffect2);
            }
        }
        if (meta instanceof FireworkEffectMeta && (fireworkEffect = (FireworkEffectMeta)meta).hasEffect()) {
            FireworkEffect fireworkEffect3 = fireworkEffect.getEffect();
            ItemInfoListener.sendFireworkEffect(sender, fireworkEffect3);
        }
        if (meta instanceof SkullMeta && (skull = (SkullMeta)meta).hasOwner() && (string = skull.getOwner()) != null) {
            sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Skull Owner: " + string);
        }
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            String string2 = StringUtil.capitalizeFirstLetter(type.name(), '_');
            String string3 = PotionNames.getName(potionMeta.getBasePotionType()).replace("Potion", string2);
            sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + string3);
            if (potionMeta.hasCustomEffects()) {
                for (PotionEffect effect : potionMeta.getCustomEffects()) {
                    sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + StringUtil.capitalizeFirstLetter(effect.getType().getName(), '_') + " " + NumberUtil.toTime(effect.getDuration() / 20));
                }
            }
        }
        if (meta instanceof BlockStateMeta && (blockStateMeta = (BlockStateMeta)meta).hasBlockState() && (blockState = blockStateMeta.getBlockState()) != null) {
            if (blockState instanceof Container) {
                Container container = (Container)blockState;
                Inventory inv = container.getInventory();
                int stacks = 0;
                for (ItemStack stack : inv.getContents()) {
                    if (stack == null || stack.getType() == Material.AIR) continue;
                    ++stacks;
                }
                if (stacks > 0) {
                    sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Content: " + stacks + " Stacks");
                }
            }
            if (blockState instanceof Beehive) {
                Beehive beehive = (Beehive)blockState;
                int bees = beehive.getEntityCount();
                sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Bees: " + bees);
            }
            if (blockState instanceof DecoratedPot) {
                DecoratedPot decoratedPot = (DecoratedPot)blockState;
                for (Map.Entry e : decoratedPot.getSherds().entrySet()) {
                    Material material = (Material)e.getValue();
                    if (material == null) continue;
                    Component c = Component.text((String)"    ").color((TextColor)NamedTextColor.GRAY);
                    c = c.append((Component)Component.translatable((String)material.getItemTranslationKey()));
                    sender.sendMessage(c);
                }
            }
        }
        if (meta instanceof TropicalFishBucketMeta && (tropicalFishBucketMeta = (TropicalFishBucketMeta)meta).hasVariant()) {
            String string4 = StringUtil.capitalizeFirstLetter(Objects.toString(tropicalFishBucketMeta.getPattern()), '_');
            String string5 = StringUtil.capitalizeFirstLetter(Objects.toString(tropicalFishBucketMeta.getBodyColor()), '_');
            String patterncolor = StringUtil.capitalizeFirstLetter(Objects.toString(tropicalFishBucketMeta.getPatternColor()), '_');
            sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Variant: " + string4 + " " + string5 + "/" + patterncolor);
        }
        if (meta instanceof AxolotlBucketMeta && (axolotlBucketMeta = (AxolotlBucketMeta)meta).hasVariant()) {
            String string6 = StringUtil.capitalizeFirstLetter(Objects.toString(axolotlBucketMeta.getVariant()), '_');
            sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Variant: " + string6);
        }
        if (meta instanceof LeatherArmorMeta && (color = (leatherArmorMeta = (LeatherArmorMeta)meta).getColor()) != null) {
            sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Color: " + ItemInfoListener.getColorHexCode(color));
        }
        if (meta instanceof ArmorMeta && (armorMeta = (ArmorMeta)meta).hasTrim()) {
            ArmorTrim armorTrim = armorMeta.getTrim();
            NamespacedKey namespacedKey = RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_MATERIAL).getKey((Keyed)armorTrim.getMaterial());
            NamespacedKey patternKey = RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_PATTERN).getKey((Keyed)armorTrim.getPattern());
            String material = namespacedKey != null ? namespacedKey.getKey().toLowerCase() : "Unknown Material";
            String trimPattern = patternKey != null ? StringUtil.capitalizeFirstLetter(patternKey.getKey()) : "Unknown Pattern";
            sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Trim: " + material + " " + trimPattern);
        }
        if (meta instanceof CrossbowMeta && (crossbowMeta = (CrossbowMeta)meta).hasChargedProjectiles()) {
            for (ItemStack itemStack : crossbowMeta.getChargedProjectiles()) {
                if (itemStack == null || itemStack.getType().isAir()) continue;
                Object arrow = StringUtil.capitalizeFirstLetter(Objects.toString(itemStack.getType()), '_');
                ItemMeta arrowMeta = itemStack.getItemMeta();
                if (arrowMeta instanceof PotionMeta) {
                    PotionMeta potion = (PotionMeta)arrowMeta;
                    StringBuilder message = new StringBuilder(50).append(" (");
                    String baseItemName = StringUtil.capitalizeFirstLetter(type.name(), '_');
                    String itemName = PotionNames.getName(potion.getBasePotionType()).replace("Potion", baseItemName);
                    message.append(itemName);
                    if (potion.hasCustomEffects()) {
                        for (PotionEffect effect : potion.getCustomEffects()) {
                            message.append(", ");
                            message.append(String.valueOf(ChatColor.GRAY) + StringUtil.capitalizeFirstLetter(effect.getType().getName(), '_') + " " + NumberUtil.toTime(effect.getDuration() / 20));
                        }
                    }
                    message.append(")");
                    arrow = (String)arrow + message.toString();
                }
                sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Projectile: " + (String)arrow);
            }
        }
        if (meta instanceof MusicInstrumentMeta) {
            void var8_36;
            MusicInstrumentMeta musicInstrumentMeta = (MusicInstrumentMeta)meta;
            MusicInstrument musicInstrument = musicInstrumentMeta.getInstrument();
            if (musicInstrument == null) {
                MusicInstrument musicInstrument2 = MusicInstrument.PONDER_GOAT_HORN;
            }
            String string7 = StringUtil.capitalizeFirstLetter(var8_36.getKey().getKey().replace("_goat_horn", ""));
            sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Instrument: " + string7);
        }
        if (meta != null && meta.hasLore() && !(meta instanceof BookMeta) && (lore = meta.getLore()) != null && lore.size() > 0) {
            if (lore.size() == 1) {
                sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Lore: " + (String)lore.get(0));
            } else {
                sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Lore:");
                for (String string8 : lore) {
                    sender.sendMessage("      " + String.valueOf(ChatColor.GRAY) + string8);
                }
            }
        }
        if (meta instanceof OminousBottleMeta) {
            OminousBottleMeta ominousBottleMeta = (OminousBottleMeta)meta;
            int n = (ominousBottleMeta.hasAmplifier() ? ominousBottleMeta.getAmplifier() : 0) + 1;
            sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + "Bad Omen" + (String)(n > 1 ? " " + NumberUtil.toRoman(n) : ""));
        }
    }

    private static void sendFireworkEffect(CommandSender sender, FireworkEffect effect) {
        sender.sendMessage("    " + String.valueOf(ChatColor.GRAY) + FireworkEffectTypeNames.getName(effect.getType()));
        List colors = effect.getColors();
        if (colors != null && !colors.isEmpty()) {
            sender.sendMessage("      " + String.valueOf(ChatColor.GRAY) + ItemInfoListener.colorListToString(colors));
        }
        if ((colors = effect.getFadeColors()) != null && !colors.isEmpty()) {
            sender.sendMessage("      " + String.valueOf(ChatColor.GRAY) + "Fade to " + ItemInfoListener.colorListToString(colors));
        }
        if (effect.hasTrail()) {
            sender.sendMessage("      " + String.valueOf(ChatColor.GRAY) + "Trail");
        }
        if (effect.hasFlicker()) {
            sender.sendMessage("      " + String.valueOf(ChatColor.GRAY) + "Twinkle");
        }
    }

    private static String colorListToString(List<Color> colors) {
        StringBuilder sb = new StringBuilder();
        for (Color c : colors) {
            DyeColor dyeColor;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append((dyeColor = DyeColor.getByFireworkColor((Color)c)) != null ? StringUtil.capitalizeFirstLetter(dyeColor.name(), '_') : "Custom");
        }
        return sb.toString();
    }

    private static String getTwoCharacterColorHexCode(int color) {
        Object s = Integer.toHexString(color).toUpperCase();
        if (((String)s).length() < 2) {
            s = "0" + (String)s;
        }
        return s;
    }

    private static String getColorHexCode(Color color) {
        String red = ItemInfoListener.getTwoCharacterColorHexCode(color.getRed());
        String green = ItemInfoListener.getTwoCharacterColorHexCode(color.getGreen());
        String blue = ItemInfoListener.getTwoCharacterColorHexCode(color.getBlue());
        return "#" + red + green + blue;
    }
}

