/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Block;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Events.ShopCreatedEvent;
import com.Acrobot.ChestShop.ItemNaming.ItemNamingUtils;
import com.Acrobot.ChestShop.Signs.ChestShopMetaData;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SignCreate
implements Listener {
    public static final String AUTOFILL_CODE = "?";
    public static final String AUTOFILL_SHULKER_CONTENT_CODE = "??";

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public static void onSignChange(SignChangeEvent event) {
        Block signBlock = event.getBlock();
        boolean wasChestShop = ChestShopSign.isChestShop(signBlock);
        if (event.getSide() == Side.BACK) {
            if (wasChestShop) {
                event.setCancelled(true);
            }
            return;
        }
        String[] line = StringUtil.stripColourCodes(event.getLines());
        if (!BlockUtil.isSign(signBlock)) {
            if (wasChestShop) {
                ChestShopSign.removeChestShopMetaData(signBlock, true);
            }
            return;
        }
        if (!ChestShopSign.isValidPreparedSign(line)) {
            if (wasChestShop) {
                ChestShopSign.removeChestShopMetaData(signBlock, true);
            }
            return;
        }
        ItemStack itemStack = SignCreate.getItemStack(event.getLine(3), (Sign)event.getBlock().getState());
        if (itemStack == null || itemStack.isEmpty()) {
            if (wasChestShop) {
                ChestShopSign.removeChestShopMetaData(signBlock, true);
            }
            return;
        }
        itemStack.setAmount(1);
        Sign sign = (Sign)signBlock.getState();
        ChestShopMetaData oldData = wasChestShop ? ChestShopSign.getChestShopMetaData(sign) : null;
        PreShopCreationEvent preEvent = new PreShopCreationEvent(event.getPlayer(), (Sign)signBlock.getState(), line, itemStack);
        if (oldData != null) {
            preEvent.setAmount(oldData.getQuantity());
            preEvent.setEnforceAmount(oldData.isEnforceQuantity());
            preEvent.setNoAutofill(oldData.isNoAutofill());
        }
        ChestShop.callEvent(preEvent);
        if (preEvent.isCancelled()) {
            if (wasChestShop) {
                ChestShopSign.removeChestShopMetaData(signBlock, true);
            }
            return;
        }
        SignSide side = sign.getSide(event.getSide());
        for (byte i = 0; i < event.getLines().length; i = (byte)(i + 1)) {
            event.setLine((int)i, preEvent.getSignLine(i));
            side.setLine((int)i, preEvent.getSignLine(i));
        }
        ChestShopMetaData chestShopMetaData = SignCreate.createShopMetaData(event.getPlayer(), preEvent.getShopOwnerId(), event.getLines(), itemStack, preEvent.getAmount(), preEvent.isEnforceAmount(), preEvent.isNoAutofill());
        ShopCreatedEvent postEvent = new ShopCreatedEvent(preEvent.getPlayer(), preEvent.getSign(), uBlock.findConnectedChest(preEvent.getSign()), preEvent.getSignLines(), chestShopMetaData);
        ChestShop.callEvent(postEvent);
        SignSide signSide = sign.getSide(Side.BACK);
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            signSide.setLine(i, "");
        }
        ChestShopSign.saveChestShopMetaData(sign, chestShopMetaData, true);
    }

    public static ChestShopMetaData createShopMetaData(Player creator, UUID shopOwnerId, String[] signLines, ItemStack itemStack, int quantity, boolean enforceQuantity, boolean noAutofill) {
        String priceLine = signLines[2];
        double sellPrice = PriceUtil.getSellPrice(priceLine);
        double buyPrice = PriceUtil.getBuyPrice(priceLine);
        return new ChestShopMetaData(shopOwnerId, quantity, enforceQuantity, sellPrice, buyPrice, itemStack, noAutofill);
    }

    private static ItemStack getItemStack(String itemLine, Sign sign) {
        ItemStack itemStack;
        String oldItemDisplayName;
        ChestShopMetaData chestShopMetaData;
        if (ChestShopSign.isChestShop(sign) && (chestShopMetaData = ChestShopSign.getChestShopMetaData(sign)) != null && (oldItemDisplayName = ItemNamingUtils.getSignItemName(itemStack = chestShopMetaData.getItemStack())).equals(itemLine)) {
            return itemStack;
        }
        ItemStack item = null;
        if (Properties.ALLOW_AUTO_ITEM_FILL && (itemLine.equals(AUTOFILL_CODE) || itemLine.equals(AUTOFILL_SHULKER_CONTENT_CODE))) {
            item = SignCreate.autoFillItemStack(sign, itemLine);
        } else {
            Material material = ItemNamingUtils.getItemFromSignName(itemLine);
            if (material != null) {
                item = new ItemStack(material);
            }
        }
        return item;
    }

    private static ItemStack autoFillItemStack(Sign sign, String itemLine) {
        Container connectedChest = uBlock.findConnectedChest(sign, true);
        if (connectedChest != null) {
            return itemLine.equals(AUTOFILL_SHULKER_CONTENT_CODE) ? SignCreate.autoFillItemStackFromShulker(connectedChest) : SignCreate.autoFillItemStackFromChest(connectedChest);
        }
        return null;
    }

    private static ItemStack autoFillItemStackFromChest(Container connectedChest) {
        for (ItemStack stack : connectedChest.getInventory().getContents()) {
            if (MaterialUtil.isEmpty(stack)) continue;
            stack = stack.clone();
            stack.setAmount(1);
            return stack;
        }
        return null;
    }

    private static ItemStack autoFillItemStackFromShulker(Container connectedChest) {
        for (ItemStack stack : connectedChest.getInventory().getContents()) {
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta meta;
            if (MaterialUtil.isEmpty(stack) || !BlockUtil.isShulkerBox(stack.getType()) || !((meta = stack.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            for (ItemStack shulkerContent : shulkerBox.getSnapshotInventory().getStorageContents()) {
                if (MaterialUtil.isEmpty(shulkerContent)) continue;
                shulkerContent = shulkerContent.clone();
                shulkerContent.setAmount(1);
                return shulkerContent;
            }
        }
        return null;
    }
}

