/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.ChestShop.Containers.AdminInventory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryUtil {
    public static int getAmount(ItemStack item, Inventory inventory) {
        if (!inventory.contains(item.getType())) {
            return 0;
        }
        if (inventory.getType() == null) {
            return Integer.MAX_VALUE;
        }
        if (inventory instanceof AdminInventory) {
            return Integer.MAX_VALUE;
        }
        int itemAmount = 0;
        for (ItemStack content : inventory.getStorageContents()) {
            if (!item.isSimilar(content)) continue;
            itemAmount += content.getAmount();
        }
        return itemAmount;
    }

    public static boolean isEmpty(Inventory inventory) {
        for (ItemStack stack : inventory.getContents()) {
            if (MaterialUtil.isEmpty(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasItems(ItemStack[] items, Inventory inventory) {
        for (ItemStack item : items) {
            if (inventory.containsAtLeast(item, item.getAmount())) continue;
            return false;
        }
        return true;
    }

    public static boolean fits(ItemStack item, Inventory inventory) {
        int left = item.getAmount();
        if (inventory.getMaxStackSize() == Integer.MAX_VALUE) {
            return true;
        }
        for (ItemStack iStack : inventory.getStorageContents()) {
            if (left <= 0) {
                return true;
            }
            if (MaterialUtil.isEmpty(iStack)) {
                left -= item.getMaxStackSize();
                continue;
            }
            if (!iStack.isSimilar(item)) continue;
            left -= iStack.getMaxStackSize() - iStack.getAmount();
        }
        return left <= 0;
    }

    public static int add(ItemStack item, Inventory inventory, int maxStackSize) {
        if (item.getAmount() < 1) {
            return 0;
        }
        int amountLeft = item.getAmount();
        int storageStacks = inventory.getStorageContents().length;
        for (int currentSlot = 0; currentSlot < storageStacks && amountLeft > 0; ++currentSlot) {
            ItemStack currentItem = inventory.getItem(currentSlot);
            ItemStack duplicate = item.clone();
            if (MaterialUtil.isEmpty(currentItem)) {
                duplicate.setAmount(Math.min(amountLeft, maxStackSize));
                duplicate.addUnsafeEnchantments(item.getEnchantments());
                amountLeft -= duplicate.getAmount();
                inventory.setItem(currentSlot, duplicate);
                continue;
            }
            if (currentItem.getAmount() >= maxStackSize || !currentItem.isSimilar(item)) continue;
            int currentAmount = currentItem.getAmount();
            int neededToAdd = Math.min(maxStackSize - currentAmount, amountLeft);
            duplicate.setAmount(currentAmount + neededToAdd);
            duplicate.addUnsafeEnchantments(item.getEnchantments());
            amountLeft -= neededToAdd;
            inventory.setItem(currentSlot, duplicate);
        }
        return amountLeft;
    }

    public static int add(ItemStack item, Inventory inventory) {
        return InventoryUtil.add(item, inventory, item.getMaxStackSize());
    }

    public static int remove(ItemStack item, Inventory inventory) {
        HashMap leftovers = inventory.removeItem(new ItemStack[]{item});
        return InventoryUtil.countItems(leftovers);
    }

    public static ItemStack[] mergeSimilarStacks(ItemStack ... items) {
        if (items.length <= 1) {
            return items;
        }
        LinkedList<ItemStack> itemList = new LinkedList<ItemStack>();
        block0: for (ItemStack item : items) {
            for (ItemStack iStack : itemList) {
                if (!item.isSimilar(iStack)) continue;
                iStack.setAmount(iStack.getAmount() + item.getAmount());
                continue block0;
            }
            itemList.add(item);
        }
        return itemList.toArray(new ItemStack[itemList.size()]);
    }

    public static int countItems(ItemStack ... items) {
        int count = 0;
        for (ItemStack item : items) {
            count += item.getAmount();
        }
        return count;
    }

    public static int countItems(Map<Integer, ?> items) {
        int totalLeft = 0;
        for (int left : items.keySet()) {
            totalLeft += left;
        }
        return totalLeft;
    }
}

