/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Metadata;

import com.Acrobot.Breeze.Utils.Encoding.Base62;
import com.Acrobot.Breeze.Utils.Encoding.Base64;
import com.Acrobot.ChestShop.Database.DaoCreator;
import com.Acrobot.ChestShop.Database.Item;
import com.Acrobot.ChestShop.ORMlite.dao.Dao;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.bukkit.inventory.ItemStack;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class ItemDatabase {
    private Dao<Item, Integer> itemDao;
    private final Yaml yaml = new Yaml((BaseConstructor)new YamlBukkitConstructor(), (Representer)new YamlRepresenter(), new DumperOptions());

    public ItemDatabase() {
        try {
            this.itemDao = DaoCreator.getDaoAndCreateTable(Item.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getItemCode(ItemStack item) {
        try {
            ItemStack clone = new ItemStack(item);
            clone.setAmount(1);
            String code = Base64.encodeObject((Serializable)((Object)this.yaml.dump((Object)clone)));
            Item itemEntity = (Item)this.itemDao.queryBuilder().where().eq("code", code).queryForFirst();
            if (itemEntity != null) {
                return Base62.encode(itemEntity.getId());
            }
            itemEntity = new Item(code);
            this.itemDao.create(itemEntity);
            int id = itemEntity.getId();
            return Base62.encode(id);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ItemStack getFromCode(String code) {
        try {
            int id = Base62.decode(code);
            Item item = (Item)this.itemDao.queryBuilder().where().eq("id", id).queryForFirst();
            if (item == null) {
                return null;
            }
            String serialized = item.getBase64ItemCode();
            return (ItemStack)this.yaml.loadAs((String)Base64.decodeToObject(serialized), ItemStack.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private class YamlBukkitConstructor
    extends YamlConstructor {
        public YamlBukkitConstructor() {
            this.yamlConstructors.put(new Tag("tag:yaml.org,2002:org.bukkit.inventory.ItemStack"), this.yamlConstructors.get(Tag.MAP));
        }
    }
}

