/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Signs;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Signs.ChestShopMetaData;
import com.Acrobot.ChestShop.Signs.LegacyChestShopSign;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import com.Acrobot.ChestShop.Utils.ItemNamingUtils;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ChestShopSign {
    public static final byte PRICE_LINE = 2;
    public static final Pattern[] SHOP_SIGN_PATTERN = new Pattern[]{Pattern.compile("^?[\\w -.]*$"), Pattern.compile("^[1-9][0-9]{0,4}$"), Pattern.compile("(?i)^[\\d.bs(free) :]+$")};
    private static NamespacedKey METADATA_NAMESPACED_KEY;

    public static void createNamespacedKeys(ChestShop chestShop) {
        METADATA_NAMESPACED_KEY = new NamespacedKey((Plugin)chestShop, "metadata");
    }

    public static boolean isAdminShop(Sign sign) {
        if (!ChestShopSign.isChestShop(sign)) {
            return false;
        }
        return ChestShopSign.getChestShopMetaData(sign).isAdminshop();
    }

    public static boolean canAccess(OfflinePlayer player, Sign sign) {
        if (player == null) {
            return false;
        }
        if (sign == null) {
            return true;
        }
        if (ChestShopSign.isOwner(player, sign)) {
            return true;
        }
        return ChestShopSign.isAccessor(player, sign);
    }

    public static boolean isOwner(OfflinePlayer player, Sign sign) {
        return ChestShopSign.getChestShopMetaData(sign).isOwner(player.getUniqueId());
    }

    public static UUID getOwner(Sign sign) {
        if (!ChestShopSign.isChestShop(sign)) {
            return null;
        }
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        return chestShopMetaData.getOwner();
    }

    public static ItemStack getItemStack(Sign sign) {
        if (!ChestShopSign.isChestShop(sign)) {
            return null;
        }
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        return chestShopMetaData.getItemStack();
    }

    public static void addAccessor(UUID player, Sign sign) {
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        chestShopMetaData.addAccessor(player);
        ChestShopSign.saveChestShopMetaData(sign, chestShopMetaData);
    }

    public static boolean isAccessor(OfflinePlayer player, Sign sign) {
        return ChestShopSign.isAccessor(player.getUniqueId(), sign);
    }

    public static boolean isAccessor(UUID player, Sign sign) {
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        return chestShopMetaData.isAccessor(player);
    }

    public static void removeAccessor(UUID accessor, Sign sign) {
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        chestShopMetaData.removeAccessor(accessor);
        ChestShopSign.saveChestShopMetaData(sign, chestShopMetaData);
    }

    private static void updateLegacyChestShop(Sign sign) {
        UUID ownerUUID = LegacyChestShopSign.getOwnerUUID(sign);
        int quantity = LegacyChestShopSign.getQuantity(sign);
        double buyPrice = LegacyChestShopSign.getBuyPrice(sign);
        double sellPrice = LegacyChestShopSign.getSellPrice(sign);
        ItemStack itemStack = LegacyChestShopSign.getItemStack(sign);
        ChestShopMetaData chestShopMetaData = new ChestShopMetaData(ownerUUID, quantity, sellPrice, buyPrice, itemStack);
        ChestShopSign.saveChestShopMetaData(sign, chestShopMetaData);
    }

    private static boolean isLegacyChestShop(Sign sign) {
        if (sign.getPersistentDataContainer().has(METADATA_NAMESPACED_KEY, PersistentDataType.STRING)) {
            return false;
        }
        if (!LegacyChestShopSign.isValid(sign)) {
            return false;
        }
        if (LegacyChestShopSign.getOwnerUUID(sign) == null) {
            return false;
        }
        return LegacyChestShopSign.getItemStack(sign) != null;
    }

    public static boolean isChestShop(Block block) {
        BlockState state = block.getState();
        if (!(state instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)state;
        return ChestShopSign.isChestShop(sign);
    }

    public static boolean isChestShop(Sign sign) {
        try {
            if (ChestShopSign.isLegacyChestShop(sign)) {
                ChestShopSign.updateLegacyChestShop(sign);
                return true;
            }
            boolean isChestshop = sign.getPersistentDataContainer().has(METADATA_NAMESPACED_KEY, PersistentDataType.STRING);
            if (isChestshop) {
                ChestShopSign.updateSignDisplay(sign);
            }
            return isChestshop;
        }
        catch (Exception e) {
            ChestShop.getBukkitLogger().log(Level.SEVERE, "Could not load shop info at " + String.valueOf(sign.getLocation()), e);
            return false;
        }
    }

    private static void updateSignDisplay(Sign sign) {
        ChestShopMetaData chestShopMetaData = ChestShopSign.getChestShopMetaData(sign);
        if (chestShopMetaData == null || chestShopMetaData.getItemStack() == null) {
            return;
        }
        UUID owner = chestShopMetaData.getOwner();
        String fullOwnerName = NameManager.getFullNameFor(owner);
        sign.setLine(0, fullOwnerName);
        sign.setLine(3, ItemNamingUtils.getSignItemName(chestShopMetaData.getItemStack()));
        sign.update();
    }

    public static ChestShopMetaData getChestShopMetaData(Sign sign) {
        try {
            String string = (String)sign.getPersistentDataContainer().get(METADATA_NAMESPACED_KEY, PersistentDataType.STRING);
            YamlConfiguration yamlConfiguration = new YamlConfiguration();
            yamlConfiguration.loadFromString(string);
            ChestShopMetaData metaData = (ChestShopMetaData)yamlConfiguration.get("metadata");
            if (metaData == null) {
                throw new NullPointerException("No metadata in:\n" + string);
            }
            if (metaData.getItemStack() == null) {
                ChestShop.getBukkitLogger().log(Level.WARNING, "No ItemStack found in:\n" + string);
                return null;
            }
            if (metaData.shouldUpdate()) {
                ChestShopSign.saveChestShopMetaData(sign, metaData);
            }
            return metaData;
        }
        catch (Exception e) {
            ChestShop.getBukkitLogger().log(Level.SEVERE, "Exception loading Chestshop Metadata (" + sign.getX() + " " + sign.getY() + " " + sign.getZ() + ").", e);
            return null;
        }
    }

    public static void saveChestShopMetaData(Sign sign, ChestShopMetaData chestShopMetaData) {
        ChestShopSign.saveChestShopMetaData(sign, chestShopMetaData, false);
    }

    public static void saveChestShopMetaData(Sign sign, ChestShopMetaData chestShopMetaData, boolean delayUpdate) {
        Runnable change = () -> {
            try {
                YamlConfiguration yamlConfiguration = new YamlConfiguration();
                yamlConfiguration.set("metadata", (Object)chestShopMetaData);
                String string = yamlConfiguration.saveToString();
                sign.getPersistentDataContainer().set(METADATA_NAMESPACED_KEY, PersistentDataType.STRING, (Object)string);
                sign.update();
            }
            catch (Exception e) {
                ChestShop.getBukkitLogger().log(Level.WARNING, "Exception saving Chestshop Metadata (" + sign.getX() + " " + sign.getY() + " " + sign.getZ() + ").", e);
            }
        };
        if (delayUpdate) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)ChestShop.getPlugin(), change, 1L);
        } else {
            change.run();
        }
    }

    public static boolean isValidPreparedSign(String[] lines) {
        for (int i = 0; i < 3; ++i) {
            if (SHOP_SIGN_PATTERN[i].matcher(lines[i]).matches()) continue;
            return false;
        }
        return lines[2].indexOf(58) == lines[2].lastIndexOf(58);
    }

    public static boolean isAdminshopLine(String ownerLine) {
        return ownerLine.replace(" ", "").equalsIgnoreCase(Properties.ADMIN_SHOP_NAME.replace(" ", ""));
    }
}

