/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Events;

import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public class PreShopCreationEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private Player creator;
    private CreationOutcome outcome = CreationOutcome.SHOP_CREATED_SUCCESSFULLY;
    private Sign sign;
    private String[] signLines;
    private final ItemStack itemStack;

    public PreShopCreationEvent(Player creator, Sign sign, String[] signLines, ItemStack itemStack) {
        this.creator = creator;
        this.sign = sign;
        this.signLines = (String[])signLines.clone();
        this.itemStack = itemStack;
        if (itemStack == null) {
            this.outcome = CreationOutcome.INVALID_ITEM;
        }
    }

    public String getQuantityLine() {
        return this.signLines[1];
    }

    public String setItemLine(String line) {
        this.signLines[3] = line;
        return this.signLines[3];
    }

    public ItemStack getItemStack() {
        if (this.itemStack == null) {
            return null;
        }
        return this.itemStack.clone();
    }

    public boolean isCancelled() {
        return this.outcome != CreationOutcome.SHOP_CREATED_SUCCESSFULLY;
    }

    public CreationOutcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(CreationOutcome outcome) {
        this.outcome = outcome;
    }

    public void setCreator(Player creator) {
        this.creator = creator;
    }

    public void setSign(Sign sign) {
        this.sign = sign;
    }

    public void setSignLines(String[] signLines) {
        this.signLines = signLines;
    }

    public void setSignLine(byte line, String text) {
        this.signLines[line] = text;
    }

    public Player getPlayer() {
        return this.creator;
    }

    public Sign getSign() {
        return this.sign;
    }

    public String getSignLine(byte line) {
        return this.signLines[line];
    }

    public String getOwnerName() {
        return this.getSignLine((byte)0);
    }

    public void setOwnerName(String name) {
        this.setSignLine((byte)0, name);
    }

    public String[] getSignLines() {
        return this.signLines;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum CreationOutcome {
        INVALID_ITEM,
        INVALID_PRICE,
        INVALID_QUANTITY,
        SELL_PRICE_HIGHER_THAN_BUY_PRICE,
        NO_CHEST,
        NO_PERMISSION,
        NO_PERMISSION_FOR_TERRAIN,
        NO_PERMISSION_FOR_CHEST,
        NOT_ENOUGH_MONEY,
        OTHER,
        SHOP_CREATED_SUCCESSFULLY;

    }
}

