/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Events.Economy;

import java.math.BigDecimal;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class CurrencyTransferEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private BigDecimal amount;
    private World world;
    private UUID sender;
    private UUID receiver;
    private boolean success;

    public CurrencyTransferEvent(BigDecimal amount, UUID sender, UUID receiver, World world) {
        this.amount = amount;
        this.world = world;
        this.sender = sender;
        this.receiver = receiver;
    }

    public CurrencyTransferEvent(double amount, UUID sender, UUID receiver, World world) {
        this(BigDecimal.valueOf(amount), sender, receiver, world);
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public double getDoubleAmount() {
        return this.amount.doubleValue();
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setAmount(double amount) {
        this.amount = BigDecimal.valueOf(amount);
    }

    public boolean hasBeenTransferred() {
        return this.success;
    }

    public void setTransferred(boolean success) {
        this.success = success;
    }

    public World getWorld() {
        return this.world;
    }

    public UUID getSender() {
        return this.sender;
    }

    public UUID getReceiver() {
        return this.receiver;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

