/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Security;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.Utils.uBlock;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class ChestChecker
implements Listener {
    @EventHandler(priority=EventPriority.LOW)
    public static void onPreShopCreation(PreShopCreationEvent event) {
        String nameLine = event.getSignLine((byte)0);
        if (ChestShopSign.isAdminShop(nameLine)) {
            return;
        }
        Chest connectedChest = uBlock.findConnectedChest(event.getSign());
        if (connectedChest == null) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_CHEST);
            return;
        }
        Player player = event.getPlayer();
        if (Permission.has((CommandSender)player, Permission.ADMIN)) {
            return;
        }
        if (!Security.canAccess(player, connectedChest.getBlock())) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.NO_PERMISSION_FOR_CHEST);
        }
    }
}

