/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.Modules;

import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.Breeze.Utils.PriceUtil;
import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class PriceRestrictionModule
implements Listener {
    private YamlConfiguration configuration;
    private static final double INVALID_PATH = Double.MIN_VALUE;

    public PriceRestrictionModule() {
        File file = new File(ChestShop.getFolder(), "priceLimits.yml");
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
        this.configuration.options().header("In this file you can configure maximum and minimum prices for items (when creating a shop).");
        if (!file.exists()) {
            this.configuration.addDefault("max.buy_price.itemID", (Object)5.53);
            this.configuration.addDefault("max.buy_price.988", (Object)3.51);
            this.configuration.addDefault("max.sell_price.978", (Object)3.52);
            this.configuration.addDefault("min.buy_price.979", (Object)1.03);
            this.configuration.addDefault("min.sell_price.989", (Object)0.51);
            try {
                this.configuration.options().copyDefaults(true);
                this.configuration.save(ChestShop.loadFile("priceLimits.yml"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onPreShopCreation(PreShopCreationEvent event) {
        ItemStack material = MaterialUtil.getItem(event.getSignLine((byte)3));
        if (material == null) {
            return;
        }
        String itemID = material.getType().name().toLowerCase();
        int amount = material.getAmount();
        if (PriceUtil.hasBuyPrice(event.getSignLine((byte)2))) {
            double buyPrice = PriceUtil.getBuyPrice(event.getSignLine((byte)2));
            if (this.isValid("min.buy_price." + itemID) && buyPrice < this.configuration.getDouble("min.buy_price." + itemID) / (double)amount) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            }
            if (this.isValid("max.buy_price." + itemID) && buyPrice > this.configuration.getDouble("max.buy_price." + itemID) / (double)amount) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            }
        }
        if (PriceUtil.hasSellPrice(event.getSignLine((byte)2))) {
            double sellPrice = PriceUtil.getSellPrice(event.getSignLine((byte)2));
            if (this.isValid("min.sell_price." + itemID) && sellPrice < this.configuration.getDouble("min.sell_price." + itemID) / (double)amount) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            }
            if (this.isValid("max.sell_price." + itemID) && sellPrice > this.configuration.getDouble("max.sell_price." + itemID) / (double)amount) {
                event.setOutcome(PreShopCreationEvent.CreationOutcome.INVALID_PRICE);
            }
        }
    }

    private boolean isValid(String path) {
        return this.configuration.getDouble(path, Double.MIN_VALUE) != Double.MIN_VALUE;
    }
}

