/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PreShopCreation;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Events.Economy.CurrencyCheckEvent;
import com.Acrobot.ChestShop.Events.PreShopCreationEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import java.math.BigDecimal;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class MoneyChecker
implements Listener {
    @EventHandler
    public static void onPreShopCreation(PreShopCreationEvent event) {
        double shopCreationPrice = Properties.SHOP_CREATION_PRICE;
        if (shopCreationPrice == 0.0) {
            return;
        }
        if (ChestShopSign.isAdminShop(event.getSignLine((byte)0))) {
            return;
        }
        Player player = event.getPlayer();
        if (Permission.has((CommandSender)player, Permission.NOFEE)) {
            return;
        }
        CurrencyCheckEvent currencyCheckEvent = new CurrencyCheckEvent(BigDecimal.valueOf(shopCreationPrice), player);
        ChestShop.callEvent(currencyCheckEvent);
        if (!currencyCheckEvent.hasEnough()) {
            event.setOutcome(PreShopCreationEvent.CreationOutcome.NOT_ENOUGH_MONEY);
        }
    }
}

