/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.Acrobot.Breeze.Utils.AlternativeItemNames;
import com.Acrobot.Breeze.Utils.StringUtil;
import com.Acrobot.ChestShop.ChestShop;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MaterialUtil {
    private static final Map<String, Material> MATERIAL_CACHE = new HashMap<String, Material>();
    private static final short MAXIMUM_SIGN_LETTERS = 15;

    public static boolean isEmpty(ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }

    public static Material getMaterial(String name) {
        String formatted = name.replaceAll(" |_", "").toUpperCase();
        if (MATERIAL_CACHE.containsKey(formatted)) {
            return MATERIAL_CACHE.get(formatted);
        }
        Material material = AlternativeItemNames.getItem(formatted);
        if (material == null) {
            material = Material.matchMaterial((String)name);
        }
        if (material != null) {
            MATERIAL_CACHE.put(formatted, material);
            return material;
        }
        int length = Short.MAX_VALUE;
        for (Map.Entry<String, Material> e : AlternativeItemNames.NAME_TO_ITEM.entrySet()) {
            String matName = e.getKey();
            if (matName.length() >= length || !matName.replace("_", "").startsWith(formatted)) continue;
            length = (short)matName.length();
            material = e.getValue();
        }
        for (Material currentMaterial : Material.values()) {
            String matName = currentMaterial.name();
            if (matName.length() >= length || !matName.replace("_", "").startsWith(formatted)) continue;
            length = (short)matName.length();
            material = currentMaterial;
        }
        MATERIAL_CACHE.put(formatted, material);
        return material;
    }

    public static String getName(Material material) {
        String name = AlternativeItemNames.getName(material);
        if (name == null) {
            name = material.name();
        }
        return StringUtil.capitalizeFirstLetter(name, '_');
    }

    public static String getSignName(ItemStack itemStack) {
        Object metaCode = "";
        if (itemStack.hasItemMeta()) {
            metaCode = "#" + Metadata.getItemCode(itemStack);
        }
        return MaterialUtil.getSignMaterialName(itemStack.getType(), (String)metaCode) + (String)metaCode;
    }

    public static ItemStack getItem(String itemName) {
        Material material;
        ItemStack itemStack = null;
        String materialString = itemName;
        String metaString = null;
        int metaStart = itemName.indexOf(35);
        if (metaStart >= 0) {
            materialString = itemName.substring(0, metaStart);
            metaString = itemName.substring(metaStart + 1);
        }
        if ((material = MaterialUtil.getMaterial(materialString)) == null) {
            return null;
        }
        if (metaString == null) {
            itemStack = new ItemStack(material);
        } else {
            ItemStack itemStackFromCode = Metadata.getFromCode(metaString);
            if (itemStackFromCode != null && (itemStackFromCode.getType() == material || MaterialUtil.getSignMaterialName(itemStackFromCode.getType(), "#" + metaString).equalsIgnoreCase(materialString))) {
                itemStack = itemStackFromCode;
            }
        }
        return itemStack;
    }

    public static String getSignMaterialName(Material material, String metadata) {
        String itemName = StringUtil.capitalizeFirstLetter(MaterialUtil.getName(material));
        if (itemName.length() > 15 - metadata.length()) {
            itemName = itemName.replace(" ", "");
        }
        if (itemName.length() > 15 - metadata.length()) {
            itemName = itemName.substring(0, 15 - metadata.length());
        }
        return itemName;
    }

    public static class Metadata {
        public static String getMetaCodeFromItemCode(String itemName) {
            int metaStart = itemName.indexOf(35);
            if (metaStart >= 0) {
                return itemName.substring(metaStart + 1);
            }
            return null;
        }

        public static ItemStack getFromCode(String code) {
            return ChestShop.getItemDatabase().getFromCode(code);
        }

        public static String getItemCode(ItemStack item) {
            return ChestShop.getItemDatabase().getItemCode(item);
        }
    }
}

