/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Listeners.PostTransaction;

import com.Acrobot.ChestShop.Commands.Toggle;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Configuration.Properties;
import com.Acrobot.ChestShop.Economy.Economy;
import com.Acrobot.ChestShop.Events.TransactionEvent;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import com.Acrobot.ChestShop.Utils.ComponentUtils;
import java.util.ArrayList;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class TransactionMessageSender
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public static void onTransaction(TransactionEvent event) {
        if (event.getTransactionType() == TransactionEvent.TransactionType.BUY) {
            TransactionMessageSender.sendBuyMessage(event);
        } else {
            TransactionMessageSender.sendSellMessage(event);
        }
    }

    protected static void sendBuyMessage(TransactionEvent event) {
        BaseComponent[] message;
        BaseComponent[] itemName = TransactionMessageSender.parseItemInformation(event.getStock());
        String owner = NameManager.getFullNameFor(event.getOwner().getUniqueId());
        Player player = event.getClient();
        String price = Economy.formatBalance(event.getPrice());
        if (Properties.SHOW_TRANSACTION_INFORMATION_CLIENT) {
            message = TransactionMessageSender.formatMessage(Messages.YOU_BOUGHT_FROM_SHOP.replace("%owner", owner), itemName, price);
            player.spigot().sendMessage(message);
        }
        if (Properties.SHOW_TRANSACTION_INFORMATION_OWNER && !Toggle.isIgnoring(event.getOwner())) {
            message = TransactionMessageSender.formatMessage(Messages.SOMEBODY_BOUGHT_FROM_YOUR_SHOP.replace("%buyer", player.getName()), itemName, price);
            TransactionMessageSender.sendMessageToOwner(message, event);
        }
    }

    protected static void sendSellMessage(TransactionEvent event) {
        BaseComponent[] message;
        BaseComponent[] itemName = TransactionMessageSender.parseItemInformation(event.getStock());
        String owner = NameManager.getFullNameFor(event.getOwner().getUniqueId());
        Player player = event.getClient();
        String price = Economy.formatBalance(event.getPrice());
        if (Properties.SHOW_TRANSACTION_INFORMATION_CLIENT) {
            message = TransactionMessageSender.formatMessage(Messages.YOU_SOLD_TO_SHOP.replace("%buyer", owner), itemName, price);
            player.spigot().sendMessage(message);
        }
        if (Properties.SHOW_TRANSACTION_INFORMATION_OWNER && !Toggle.isIgnoring(event.getOwner())) {
            message = TransactionMessageSender.formatMessage(Messages.SOMEBODY_SOLD_TO_YOUR_SHOP.replace("%seller", player.getName()), itemName, price);
            TransactionMessageSender.sendMessageToOwner(message, event);
        }
    }

    private static BaseComponent[] parseItemInformation(ItemStack item) {
        ArrayList<Object> message = new ArrayList<Object>();
        message.add(new TextComponent(item.getAmount() + " "));
        message.add(ComponentUtils.getLocalizedItemName(item.getType()));
        return message.toArray(new BaseComponent[message.size()]);
    }

    private static void sendMessageToOwner(BaseComponent[] message, TransactionEvent event) {
        UUID owner = event.getOwner().getUniqueId();
        Player player = Bukkit.getPlayer((UUID)owner);
        if (player != null) {
            player.spigot().sendMessage(message);
        }
    }

    private static BaseComponent[] formatMessage(String message, BaseComponent[] itemName, String price) {
        String search;
        int start = (message = Messages.prefix(message).replace("%price", price)).indexOf(search = "%item");
        if (start < 0) {
            return TextComponent.fromLegacyText((String)message);
        }
        BaseComponent[] messageComponents = TextComponent.fromLegacyText((String)message.substring(0, start));
        BaseComponent last = messageComponents[messageComponents.length - 1];
        if (itemName.length > 0) {
            last.addExtra((BaseComponent)new TextComponent(itemName));
        }
        last.addExtra((BaseComponent)new TextComponent(TextComponent.fromLegacyText((String)message.substring(start + search.length()))));
        return messageComponents;
    }
}

