/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Plugins;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.ChestShop.Events.Protection.ProtectionCheckEvent;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import com.Acrobot.ChestShop.UUIDs.NameManager;
import com.Acrobot.ChestShop.Utils.uBlock;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ChestShop
implements Listener {
    @EventHandler
    public static void onProtectionCheck(ProtectionCheckEvent event) {
        if (event.getResult() == Event.Result.DENY || event.isBuiltInProtectionIgnored()) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (!ChestShop.canAccess(player, block)) {
            event.setResult(Event.Result.DENY);
        }
    }

    public static boolean canAccess(Player player, Block block) {
        Sign sign;
        if (Permission.has((CommandSender)player, Permission.ADMIN) || !ChestShop.canBeProtected(block)) {
            return true;
        }
        if (BlockUtil.isSign(block)) {
            sign = (Sign)block.getState();
            if (!ChestShopSign.isValid(sign)) {
                return true;
            }
            if (!ChestShop.isShopMember(player, sign)) {
                return false;
            }
        }
        return !BlockUtil.isChest(block) || (sign = uBlock.getConnectedSign(block)) == null || ChestShop.isShopMember(player, sign);
    }

    private static boolean canBeProtected(Block block) {
        return BlockUtil.isSign(block) || BlockUtil.isChest(block);
    }

    private static boolean isShopMember(Player player, Sign sign) {
        return NameManager.canUseName((OfflinePlayer)player, sign.getLine(0));
    }
}

