/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.Breeze.Utils;

import com.Acrobot.Breeze.Utils.BlockUtil;
import com.Acrobot.Breeze.Utils.MaterialUtil;
import com.Acrobot.ChestShop.Containers.AdminInventory;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryUtil {
    public static int getAmount(ItemStack item, Inventory inventory) {
        if (inventory.getType() == null) {
            return Integer.MAX_VALUE;
        }
        if (inventory instanceof AdminInventory) {
            return Integer.MAX_VALUE;
        }
        boolean isPlayerInventory = inventory instanceof PlayerInventory;
        int playerItemSlot = isPlayerInventory ? ((PlayerInventory)inventory).getHeldItemSlot() : -1;
        int itemAmount = 0;
        ItemStack[] contents = inventory.getStorageContents();
        for (int i = 0; i < contents.length; ++i) {
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta meta;
            ItemStack content = contents[i];
            if (item.isSimilar(content)) {
                itemAmount += content.getAmount();
                continue;
            }
            if (isPlayerInventory && playerItemSlot != i || content == null || !BlockUtil.isShulkerBox(content.getType()) || !((meta = content.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            for (ItemStack shulkerContent : shulkerBox.getSnapshotInventory().getStorageContents()) {
                if (shulkerContent == null || !item.isSimilar(shulkerContent)) continue;
                itemAmount += shulkerContent.getAmount();
            }
        }
        return itemAmount;
    }

    public static boolean isEmpty(Inventory inventory) {
        for (ItemStack stack : inventory.getContents()) {
            if (MaterialUtil.isEmpty(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasItems(ItemStack item, Inventory inventory) {
        if (inventory.getType() == null) {
            return true;
        }
        if (inventory instanceof AdminInventory) {
            return true;
        }
        boolean isPlayerInventory = inventory instanceof PlayerInventory;
        int playerItemSlot = isPlayerInventory ? ((PlayerInventory)inventory).getHeldItemSlot() : -1;
        int missingAmount = item.getAmount();
        ItemStack[] contents = inventory.getStorageContents();
        for (int i = 0; i < contents.length; ++i) {
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta meta;
            ItemStack content = contents[i];
            if (item.isSimilar(content)) {
                if ((missingAmount -= content.getAmount()) > 0) continue;
                return true;
            }
            if (isPlayerInventory && playerItemSlot != i || content == null || !BlockUtil.isShulkerBox(content.getType()) || !((meta = content.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            for (ItemStack shulkerContent : shulkerBox.getSnapshotInventory().getStorageContents()) {
                if (shulkerContent == null || !item.isSimilar(shulkerContent) || (missingAmount -= shulkerContent.getAmount()) > 0) continue;
                return true;
            }
        }
        return false;
    }

    public static int getFreeSpace(ItemStack item, Inventory inventory) {
        if (inventory.getType() == null) {
            return Integer.MAX_VALUE;
        }
        if (inventory instanceof AdminInventory) {
            return Integer.MAX_VALUE;
        }
        boolean isPlayerInventory = inventory instanceof PlayerInventory;
        int playerItemSlot = isPlayerInventory ? ((PlayerInventory)inventory).getHeldItemSlot() : -1;
        boolean canBeStoredInShulker = BlockUtil.canBeStoredInShulkerBox(item.getType());
        int freeSpace = 0;
        int maxStack = Math.max(item.getMaxStackSize(), 1);
        ItemStack[] contents = inventory.getStorageContents();
        for (int i = 0; i < contents.length; ++i) {
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta meta;
            ItemStack content = contents[i];
            if (item.isSimilar(content)) {
                freeSpace += Math.max(maxStack - content.getAmount(), 0);
                continue;
            }
            if (MaterialUtil.isEmpty(content)) {
                freeSpace += maxStack;
                continue;
            }
            if (isPlayerInventory && playerItemSlot != i || !canBeStoredInShulker || content == null || !BlockUtil.isShulkerBox(content.getType()) || !((meta = content.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            for (ItemStack shulkerContent : shulkerBox.getSnapshotInventory().getStorageContents()) {
                if (shulkerContent != null && item.isSimilar(shulkerContent)) {
                    freeSpace += Math.max(maxStack - shulkerContent.getAmount(), 0);
                    continue;
                }
                if (!MaterialUtil.isEmpty(shulkerContent)) continue;
                freeSpace += maxStack;
            }
        }
        return freeSpace;
    }

    public static boolean fits(ItemStack item, Inventory inventory) {
        if (inventory.getType() == null) {
            return true;
        }
        if (inventory instanceof AdminInventory) {
            return true;
        }
        if (inventory.getMaxStackSize() == Integer.MAX_VALUE) {
            return true;
        }
        boolean isPlayerInventory = inventory instanceof PlayerInventory;
        int playerItemSlot = isPlayerInventory ? ((PlayerInventory)inventory).getHeldItemSlot() : -1;
        boolean canBeStoredInShulker = BlockUtil.canBeStoredInShulkerBox(item.getType());
        int left = item.getAmount();
        int maxStack = Math.max(item.getMaxStackSize(), 1);
        ItemStack[] contents = inventory.getStorageContents();
        for (int i = 0; i < contents.length; ++i) {
            BlockStateMeta bsm;
            BlockState blockState;
            ItemMeta meta;
            ItemStack content = contents[i];
            if (item.isSimilar(content)) {
                if ((left -= Math.max(maxStack - content.getAmount(), 0)) > 0) continue;
                return true;
            }
            if (MaterialUtil.isEmpty(content)) {
                if ((left -= maxStack) > 0) continue;
                return true;
            }
            if (isPlayerInventory && playerItemSlot != i || !canBeStoredInShulker || content == null || !BlockUtil.isShulkerBox(content.getType()) || !((meta = content.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            for (ItemStack shulkerContent : shulkerBox.getSnapshotInventory().getStorageContents()) {
                if (!(shulkerContent != null && item.isSimilar(shulkerContent) ? (left -= Math.max(maxStack - shulkerContent.getAmount(), 0)) <= 0 : MaterialUtil.isEmpty(shulkerContent) && (left -= maxStack) <= 0)) continue;
                return true;
            }
        }
        return false;
    }

    public static int add(ItemStack item, Inventory inventory, int maxStackSize) {
        ItemStack content;
        int currentSlot;
        int playerItemSlot;
        if (item.getAmount() <= 0) {
            return 0;
        }
        if (inventory.getType() == null) {
            return 0;
        }
        if (inventory instanceof AdminInventory) {
            return 0;
        }
        int left = item.getAmount();
        ItemStack[] contents = inventory.getStorageContents();
        boolean contentChanged = false;
        int contentsLength = contents.length;
        boolean isPlayerInventory = inventory instanceof PlayerInventory;
        int n = playerItemSlot = isPlayerInventory ? ((PlayerInventory)inventory).getHeldItemSlot() : -1;
        if (BlockUtil.canBeStoredInShulkerBox(item.getType())) {
            for (currentSlot = 0; currentSlot < contentsLength && left > 0; ++currentSlot) {
                BlockStateMeta bsm;
                BlockState blockState;
                ItemMeta meta;
                content = contents[currentSlot];
                if (isPlayerInventory && playerItemSlot != currentSlot || content == null || !BlockUtil.isShulkerBox(content.getType()) || !((meta = content.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
                ShulkerBox shulkerBox = (ShulkerBox)blockState;
                ItemStack[] shulkerContents = shulkerBox.getSnapshotInventory().getStorageContents();
                int shulkerContentsLength = shulkerContents.length;
                boolean shulkerContentChanged = false;
                for (int currentShulkerSlot = 0; currentShulkerSlot < shulkerContentsLength && left > 0; ++currentShulkerSlot) {
                    ItemStack shulkerContent = shulkerContents[currentShulkerSlot];
                    int addHere = 0;
                    int oldAmount = 0;
                    if (shulkerContent != null && item.isSimilar(shulkerContent)) {
                        oldAmount = shulkerContent.getAmount();
                        addHere = Math.min(left, Math.max(maxStackSize - oldAmount, 0));
                    } else if (MaterialUtil.isEmpty(shulkerContent)) {
                        addHere = Math.min(left, maxStackSize);
                    }
                    if (addHere <= 0) continue;
                    left -= addHere;
                    shulkerContent = new ItemStack(item);
                    shulkerContent.setAmount(oldAmount + addHere);
                    shulkerContents[currentShulkerSlot] = shulkerContent;
                    shulkerContentChanged = true;
                }
                if (!shulkerContentChanged) continue;
                shulkerBox.getSnapshotInventory().setStorageContents(shulkerContents);
                bsm.setBlockState((BlockState)shulkerBox);
                content.setItemMeta(meta);
                contentChanged = true;
            }
        }
        for (currentSlot = 0; currentSlot < contentsLength && left > 0; ++currentSlot) {
            content = contents[currentSlot];
            int addHere = 0;
            int oldAmount = 0;
            if (content != null && item.isSimilar(content)) {
                oldAmount = content.getAmount();
                addHere = Math.min(left, Math.max(maxStackSize - oldAmount, 0));
            } else if (MaterialUtil.isEmpty(content)) {
                addHere = Math.min(left, maxStackSize);
            }
            if (addHere <= 0) continue;
            left -= addHere;
            content = new ItemStack(item);
            content.setAmount(oldAmount + addHere);
            contents[currentSlot] = content;
            contentChanged = true;
        }
        if (contentChanged) {
            inventory.setStorageContents(contents);
        }
        return left;
    }

    public static int add(ItemStack item, Inventory inventory) {
        return InventoryUtil.add(item, inventory, item.getMaxStackSize());
    }

    public static int remove(ItemStack item, Inventory inventory) {
        ItemStack content;
        int currentSlot;
        int playerItemSlot;
        if (item.getAmount() <= 0) {
            return 0;
        }
        if (inventory.getType() == null) {
            return 0;
        }
        if (inventory instanceof AdminInventory) {
            return 0;
        }
        int left = item.getAmount();
        ItemStack[] contents = inventory.getStorageContents();
        boolean contentChanged = false;
        int contentsLength = contents.length;
        boolean isPlayerInventory = inventory instanceof PlayerInventory;
        int n = playerItemSlot = isPlayerInventory ? ((PlayerInventory)inventory).getHeldItemSlot() : -1;
        if (BlockUtil.canBeStoredInShulkerBox(item.getType())) {
            for (currentSlot = 0; currentSlot < contentsLength && left > 0; ++currentSlot) {
                BlockStateMeta bsm;
                BlockState blockState;
                ItemMeta meta;
                content = contents[currentSlot];
                if (isPlayerInventory && playerItemSlot != currentSlot || content == null || !BlockUtil.isShulkerBox(content.getType()) || !((meta = content.getItemMeta()) instanceof BlockStateMeta) || !((blockState = (bsm = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox)) continue;
                ShulkerBox shulkerBox = (ShulkerBox)blockState;
                ItemStack[] shulkerContents = shulkerBox.getSnapshotInventory().getStorageContents();
                int shulkerContentsLength = shulkerContents.length;
                boolean shulkerContentChanged = false;
                for (int currentShulkerSlot = 0; currentShulkerSlot < shulkerContentsLength && left > 0; ++currentShulkerSlot) {
                    ItemStack shulkerContent = shulkerContents[currentShulkerSlot];
                    if (shulkerContent == null || !item.isSimilar(shulkerContent)) continue;
                    int oldAmount = shulkerContent.getAmount();
                    int removeHere = Math.min(left, oldAmount);
                    left -= removeHere;
                    if (removeHere < oldAmount) {
                        shulkerContent = new ItemStack(item);
                        shulkerContent.setAmount(oldAmount - removeHere);
                        shulkerContents[currentShulkerSlot] = shulkerContent;
                    } else {
                        shulkerContents[currentShulkerSlot] = null;
                    }
                    shulkerContentChanged = true;
                }
                if (!shulkerContentChanged) continue;
                shulkerBox.getSnapshotInventory().setStorageContents(shulkerContents);
                bsm.setBlockState((BlockState)shulkerBox);
                content.setItemMeta(meta);
                contentChanged = true;
            }
        }
        for (currentSlot = 0; currentSlot < contentsLength && left > 0; ++currentSlot) {
            content = contents[currentSlot];
            if (content == null || !item.isSimilar(content)) continue;
            int oldAmount = content.getAmount();
            int removeHere = Math.min(left, oldAmount);
            left -= removeHere;
            if (removeHere < oldAmount) {
                content = new ItemStack(item);
                content.setAmount(oldAmount - removeHere);
                contents[currentSlot] = content;
            } else {
                contents[currentSlot] = null;
            }
            contentChanged = true;
        }
        if (contentChanged) {
            inventory.setStorageContents(contents);
        }
        return left;
    }
}

