/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.ORMlite.field.types;

import com.Acrobot.ChestShop.ORMlite.field.FieldType;
import com.Acrobot.ChestShop.ORMlite.field.SqlType;
import com.Acrobot.ChestShop.ORMlite.field.types.BaseDataType;
import com.Acrobot.ChestShop.ORMlite.support.DatabaseResults;
import java.sql.SQLException;

public class LongObjectType
extends BaseDataType {
    private static final LongObjectType singleTon = new LongObjectType();

    public static LongObjectType getSingleton() {
        return singleTon;
    }

    private LongObjectType() {
        super(SqlType.LONG, new Class[]{Long.class});
    }

    protected LongObjectType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        return Long.parseLong(defaultStr);
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getLong(columnPos);
    }

    @Override
    public Object convertIdNumber(Number number) {
        return number.longValue();
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }

    @Override
    public boolean isValidGeneratedType() {
        return true;
    }

    @Override
    public boolean isValidForVersion() {
        return true;
    }

    @Override
    public Object moveToNextValue(Object currentValue) {
        if (currentValue == null) {
            return 1L;
        }
        return (Long)currentValue + 1L;
    }
}

