/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Commands;

import com.Acrobot.ChestShop.ChestShop;
import com.Acrobot.ChestShop.Configuration.Messages;
import com.Acrobot.ChestShop.Permission;
import com.Acrobot.ChestShop.Signs.ChestShopSign;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.util.RayTraceResult;

public class SetAmount
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        if (!Permission.has(sender, Permission.SET_AMOUNT_COMMAND)) {
            sender.sendMessage(Messages.ACCESS_DENIED);
            return true;
        }
        Player player = (Player)sender;
        RayTraceResult result = player.rayTraceBlocks(8.0);
        Block signBlock = null;
        if (result != null) {
            signBlock = result.getHitBlock();
        }
        if (signBlock == null || !ChestShopSign.isValid(signBlock)) {
            sender.sendMessage(Messages.MUST_LOOK_AT_SHOP_SIGN);
            return true;
        }
        Sign sign = (Sign)signBlock.getState();
        if (!ChestShopSign.canAccess(player, sign) && !Permission.has((CommandSender)player, Permission.ADMIN)) {
            sender.sendMessage(Messages.ACCESS_DENIED);
            return true;
        }
        String newAmountLine = String.join((CharSequence)" ", args);
        String[] line = sign.getLines();
        line[1] = newAmountLine;
        if (!ChestShopSign.isValidPreparedSign(line)) {
            sender.sendMessage(Messages.INVALID_AMOUNT_LINE);
            return true;
        }
        SignChangeEvent event = new SignChangeEvent(signBlock, player, line);
        ChestShop.getPlugin().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            sender.sendMessage(Messages.SHOP_UPDATE_FAILED);
            return true;
        }
        line = event.getLines();
        for (int i = 0; i < line.length; ++i) {
            sign.setLine(i, line[i]);
        }
        sign.update();
        return true;
    }
}

